/*
 * Decompiled with CFR 0.152.
 */
package org.multimc.onesix;

import java.applet.Applet;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.multimc.Launcher;
import org.multimc.LegacyFrame;
import org.multimc.NotFoundException;
import org.multimc.ParamBucket;
import org.multimc.Utils;

public class OneSixLauncher
implements Launcher {
    private List<String> libraries;
    private List<String> extlibs;
    private List<String> mcparams;
    private List<String> mods;
    private List<String> jarmods;
    private List<String> coremods;
    private List<String> traits;
    private String appletClass;
    private String mainClass;
    private String natives;
    private String userName;
    private String sessionId;
    private String windowTitle;
    private String windowParams;
    private Dimension winSize;
    private boolean maximize;
    private String cwd;
    private ClassLoader cl;

    private void processParams(ParamBucket paramBucket) throws NotFoundException {
        this.libraries = paramBucket.all("cp");
        this.extlibs = paramBucket.all("ext");
        this.mcparams = paramBucket.allSafe("param", new ArrayList<String>());
        this.mainClass = paramBucket.firstSafe("mainClass", "net.minecraft.client.Minecraft");
        this.appletClass = paramBucket.firstSafe("appletClass", "net.minecraft.client.MinecraftApplet");
        this.mods = paramBucket.allSafe("mod", new ArrayList<String>());
        this.jarmods = paramBucket.allSafe("jarmod", new ArrayList<String>());
        this.coremods = paramBucket.allSafe("coremod", new ArrayList<String>());
        this.traits = paramBucket.allSafe("traits", new ArrayList<String>());
        this.natives = paramBucket.first("natives");
        this.userName = paramBucket.first("userName");
        this.sessionId = paramBucket.first("sessionId");
        this.windowTitle = paramBucket.firstSafe("windowTitle", "Minecraft");
        this.windowParams = paramBucket.firstSafe("windowParams", "854x480");
        this.cwd = System.getProperty("user.dir");
        this.winSize = new Dimension(854, 480);
        this.maximize = false;
        String[] stringArray = this.windowParams.split("x");
        if (this.windowParams.equalsIgnoreCase("max")) {
            this.maximize = true;
        } else if (stringArray.length == 2) {
            try {
                this.winSize = new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void printStats() {
        Utils.log("Main Class:");
        Utils.log("  " + this.mainClass);
        Utils.log();
        Utils.log("Native path:");
        Utils.log("  " + this.natives);
        Utils.log();
        Utils.log("Traits:");
        Utils.log("  " + this.traits);
        Utils.log();
        Utils.log("Libraries:");
        for (String string : this.libraries) {
            File file = new File(string);
            if (file.exists()) {
                Utils.log("  " + string);
                continue;
            }
            Utils.log("  " + string + " (missing)", "Warning");
        }
        Utils.log();
        if (this.mods.size() > 0) {
            Utils.log("Mods:");
            for (String string : this.mods) {
                Utils.log("  " + string);
            }
            Utils.log();
        }
        if (this.coremods.size() > 0) {
            Utils.log("Core Mods:");
            for (String string : this.coremods) {
                Utils.log("  " + string);
            }
            Utils.log();
        }
        if (this.jarmods.size() > 0) {
            Utils.log("Jar Mods:");
            for (String string : this.jarmods) {
                Utils.log("  " + string);
            }
            Utils.log();
        }
        Utils.log("Params:");
        Utils.log("  " + this.mcparams.toString());
        Utils.log();
        if (this.maximize) {
            Utils.log("Window size: max (if available)");
        } else {
            Utils.log("Window size: " + Integer.toString(this.winSize.width) + " x " + Integer.toString(this.winSize.height));
        }
        Utils.log();
    }

    int legacyLaunch() {
        String[] stringArray;
        Class<?> clazz;
        try {
            clazz = this.cl.loadClass(this.mainClass);
            stringArray = Utils.getMCPathField(clazz);
            if (stringArray == null) {
                System.err.println("Could not find Minecraft path field.");
            } else {
                stringArray.setAccessible(true);
                stringArray.set(null, new File(this.cwd));
            }
        }
        catch (Exception exception) {
            System.err.println("Could not set base folder. Failed to find/access Minecraft main class:");
            exception.printStackTrace(System.err);
            return -1;
        }
        System.setProperty("minecraft.applet.TargetDirectory", this.cwd);
        stringArray = new String[]{this.userName, this.sessionId};
        Utils.log("Launching with applet wrapper...");
        try {
            Class<?> clazz2 = this.cl.loadClass(this.appletClass);
            Applet applet = (Applet)clazz2.newInstance();
            LegacyFrame legacyFrame = new LegacyFrame(this.windowTitle);
            legacyFrame.start(applet, this.userName, this.sessionId, this.winSize, this.maximize);
        }
        catch (Exception exception) {
            Utils.log("Applet wrapper failed:", "Error");
            exception.printStackTrace(System.err);
            Utils.log();
            Utils.log("Falling back to compatibility mode.");
            try {
                clazz.getMethod("main", String[].class).invoke(null, new Object[]{stringArray});
            }
            catch (Exception exception2) {
                Utils.log("Failed to invoke the Minecraft main class:", "Fatal");
                exception2.printStackTrace(System.err);
                return -1;
            }
        }
        return 0;
    }

    int launchWithMainClass() {
        Method method;
        Class<?> clazz;
        if (!this.maximize) {
            this.mcparams.add("--width");
            this.mcparams.add(Integer.toString(this.winSize.width));
            this.mcparams.add("--height");
            this.mcparams.add(Integer.toString(this.winSize.height));
        }
        try {
            clazz = this.cl.loadClass(this.mainClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Failed to find Minecraft main class:");
            classNotFoundException.printStackTrace(System.err);
            return -1;
        }
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Failed to acquire the main method:");
            noSuchMethodException.printStackTrace(System.err);
            return -1;
        }
        String[] stringArray = this.mcparams.toArray(new String[this.mcparams.size()]);
        try {
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            System.err.println("Failed to start Minecraft:");
            exception.printStackTrace(System.err);
            return -1;
        }
        return 0;
    }

    @Override
    public int launch(ParamBucket paramBucket) {
        try {
            this.processParams(paramBucket);
        }
        catch (NotFoundException notFoundException) {
            System.err.println("Not enough arguments.");
            notFoundException.printStackTrace(System.err);
            return -1;
        }
        if (!Utils.addToClassPath(this.libraries)) {
            System.err.println("Halting launch due to previous errors.");
            return -1;
        }
        this.printStats();
        Utils.log("Preparing native libraries...");
        String string = System.getProperty("os.arch");
        boolean bl = string.equalsIgnoreCase("x86_64") || string.equalsIgnoreCase("amd64");
        for (String string2 : this.extlibs) {
            try {
                String string3 = string2.replace("${arch}", bl ? "64" : "32");
                File file = new File(string3);
                Utils.log("Extracting " + file.getName());
                Utils.unzipNatives(file, new File(this.natives));
            }
            catch (IOException iOException) {
                System.err.println("Failed to extract native library:");
                iOException.printStackTrace(System.err);
                return -1;
            }
        }
        Utils.log();
        try {
            System.setProperty("java.library.path", this.natives);
            System.setProperty("org.lwjgl.librarypath", this.natives);
            System.setProperty("net.java.games.input.librarypath", this.natives);
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Exception exception) {
            System.err.println("Failed to set the native library path:");
            exception.printStackTrace(System.err);
            return -1;
        }
        this.cl = ClassLoader.getSystemClassLoader();
        if (this.traits.contains("legacyLaunch") || this.traits.contains("alphaLaunch")) {
            return this.legacyLaunch();
        }
        return this.launchWithMainClass();
    }
}

