/*
 * Decompiled with CFR 0.152.
 */
package org.multimc;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class IconLoader {
    public static ByteBuffer[] load(String string) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new ByteBuffer[0];
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{IconLoader.loadInstance(bufferedImage, 128)};
        return byteBufferArray;
    }

    private static ByteBuffer loadInstance(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        double d = IconLoader.getIconRatio(bufferedImage, bufferedImage2);
        double d2 = (double)bufferedImage.getWidth() * d;
        double d3 = (double)bufferedImage.getHeight() * d;
        graphics2D.drawImage(bufferedImage, (int)(((double)bufferedImage2.getWidth() - d2) / 2.0), (int)(((double)bufferedImage2.getHeight() - d3) / 2.0), (int)d2, (int)d3, null);
        graphics2D.dispose();
        return IconLoader.convertToByteBuffer(bufferedImage2);
    }

    private static double getIconRatio(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        double d = 1.0;
        d = bufferedImage.getWidth() > bufferedImage2.getWidth() ? (double)bufferedImage2.getWidth() / (double)bufferedImage.getWidth() : (double)(bufferedImage2.getWidth() / bufferedImage.getWidth());
        if (bufferedImage.getHeight() > bufferedImage2.getHeight()) {
            double d2 = (double)bufferedImage2.getHeight() / (double)bufferedImage.getHeight();
            if (d2 < d) {
                d = d2;
            }
        } else {
            double d3 = bufferedImage2.getHeight() / bufferedImage.getHeight();
            if (d3 < d) {
                d = d3;
            }
        }
        return d;
    }

    public static ByteBuffer convertToByteBuffer(BufferedImage bufferedImage) {
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n2 = bufferedImage.getRGB(j, i);
                byArray[n + 0] = (byte)(n2 << 8 >> 24);
                byArray[n + 1] = (byte)(n2 << 16 >> 24);
                byArray[n + 2] = (byte)(n2 << 24 >> 24);
                byArray[n + 3] = (byte)(n2 >> 24);
                n += 4;
            }
        }
        return ByteBuffer.wrap(byArray);
    }
}

