/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import by.gdev.utils.service.FileMapperService;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.component.RefreshableComponent;
import org.tlauncher.tlauncher.entity.profile.ClientProfile;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.managers.ProfileManagerAdapter;
import org.tlauncher.tlauncher.managers.ProfileManagerListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.browser.BrowserHolder;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.advertising.AdvertisingStatusObservable;

public class ProfileManager
extends RefreshableComponent {
    private static final String DEFAULT_PROFILE_FILENAME = "TlauncherProfiles.json";
    private static final String LAUNCHER_PROFILE_FILENAME = "launcher_profiles.json";
    private final List<ProfileManagerListener> listeners = Collections.synchronizedList(new ArrayList());
    private final FileMapperService fileMapperService = (FileMapperService)TLauncher.getInjector().getInstance(Key.get(FileMapperService.class, (Annotation)Names.named((String)"profileFileMapperService")));
    private volatile ClientProfile clientProfile;

    public ProfileManager(ComponentManager manager) throws Exception {
        super(manager);
        this.addListener(new ProfileManagerAdapter(){
            private boolean init;

            @Override
            public void fireRefreshed(ClientProfile clientProfile) {
                if (this.init) {
                    return;
                }
                this.init = true;
                TLauncher.getInstance().getTLauncherManager().asyncRefresh();
                AdvertisingStatusObservable adStatus = new AdvertisingStatusObservable(clientProfile);
                if (BrowserHolder.getInstance().getBrowser() != null) {
                    adStatus.addListeners(BrowserHolder.getInstance().getBrowser());
                }
                adStatus.run();
            }
        });
    }

    @Override
    public boolean refresh() {
        this.loadProfiles();
        this.fireProfileRefreshed();
        try {
            this.saveProfiles();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void fireProfileRefreshed() {
        for (ProfileManagerListener listener : this.listeners) {
            listener.fireRefreshed(this.clientProfile);
        }
    }

    public UUID getClientToken() {
        return this.clientProfile.getClientToken();
    }

    public void addListener(ProfileManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isNotPremium() {
        return this.clientProfile.getAccounts().values().stream().noneMatch(Account::isPremiumAccount);
    }

    public boolean remove(Account account) throws IOException {
        Account ac = this.clientProfile.getAccounts().get(account.getShortUUID());
        if (Objects.nonNull(ac)) {
            this.clientProfile.getAccounts().remove(account.getShortUUID());
            this.saveProfiles();
            this.fireProfileChanged();
            return true;
        }
        this.fireProfileChanged();
        return false;
    }

    public void save(Account account) throws IOException {
        U.log("saved account " + account.toString());
        this.clientProfile.getAccounts().put(account.getShortUUID(), account);
        this.clientProfile.setSelectedAccountUUID(account.getShortUUID());
        this.saveProfiles();
        this.fireProfileChanged();
    }

    public Account getSelectedAccount() {
        if (Objects.isNull(this.clientProfile.getSelectedAccountUUID())) {
            return null;
        }
        return this.clientProfile.getAccounts().get(this.clientProfile.getSelectedAccountUUID());
    }

    public boolean hasSelectedAccount() {
        return Objects.nonNull(this.getSelectedAccount());
    }

    public void selectAccount(Account account) {
        if (!account.getShortUUID().equals(this.clientProfile.getSelectedAccountUUID())) {
            this.clientProfile.setSelectedAccountUUID(account.getShortUUID());
            this.saveProfiles();
        }
    }

    public void updateFreeAccountField(String username) {
        Account ac;
        Optional<Account> op = this.clientProfile.getAccounts().values().stream().filter(e -> Objects.equals(e.getShortUUID(), this.clientProfile.getFreeAccountUUID())).findFirst();
        if (op.isPresent() && !Objects.equals(op.get().getUsername(), this.clientProfile.getFreeAccountUUID())) {
            ac = op.get();
            ac.setUsername(username);
            ac.setUserID(username);
            ac.setDisplayName(username);
        } else {
            ac = Account.createFreeAccountByUsername(username);
            this.clientProfile.setFreeAccountUUID(ac.getShortUUID());
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            this.remove(ac);
        } else {
            this.save(ac);
        }
        TLauncher.getInstance().getConfiguration().set("login.account", null);
    }

    private File getProfileFile() {
        return new File(MinecraftUtil.getWorkingDirectory(), DEFAULT_PROFILE_FILENAME);
    }

    private void fireProfileChanged() {
        for (ProfileManagerListener listener : this.listeners) {
            listener.fireClientProfileChanged(this.clientProfile);
        }
    }

    private void loadProfiles() {
        this.log("Refreshing profiles from:", this.getProfileFile());
        try {
            this.clientProfile = this.fileMapperService.read(DEFAULT_PROFILE_FILENAME, ClientProfile.class);
            if (Objects.isNull(this.clientProfile)) {
                this.clientProfile = new ClientProfile();
            }
            this.setOldField();
            this.removedNotValidAccounts();
        }
        catch (Exception e) {
            this.log("Cannot read from", DEFAULT_PROFILE_FILENAME, e);
            this.clientProfile = new ClientProfile();
        }
    }

    private void removedNotValidAccounts() {
        this.clientProfile.getAccounts().entrySet().stream().filter(e -> Objects.isNull(((Account)e.getValue()).getShortUUID()) || StringUtils.isBlank((CharSequence)((Account)e.getValue()).getUsername()) || ((String)e.getKey()).contains("-") || Objects.isNull(e.getKey()) || !((String)e.getKey()).equals(((Account)e.getValue()).getShortUUID())).collect(Collectors.toList()).forEach(e -> {
            U.log("removed account with null uuid or username " + ((Account)e.getValue()).toString());
            this.clientProfile.getAccounts().remove(e.getKey());
        });
        if (StringUtils.contains((CharSequence)this.clientProfile.getFreeAccountUUID(), (CharSequence)"-")) {
            this.clientProfile.setFreeAccountUUID(null);
        }
        if (StringUtils.contains((CharSequence)this.clientProfile.getSelectedAccountUUID(), (CharSequence)"-")) {
            this.clientProfile.setSelectedAccountUUID(null);
        }
        this.createStandardOfficialProfileFile();
    }

    private void setOldField() {
        if (Objects.nonNull(this.clientProfile.getAuthenticationDatabase())) {
            this.clientProfile.setAccounts(new HashMap<String, Account>());
            for (Account c : this.clientProfile.getAuthenticationDatabase().getAccounts()) {
                this.clientProfile.getAccounts().put(c.getShortUUID(), c);
            }
            this.clientProfile.setAuthenticationDatabase(null);
        }
    }

    private void createStandardOfficialProfileFile() {
        File launcherProfile = new File(MinecraftUtil.getWorkingDirectory(), LAUNCHER_PROFILE_FILENAME);
        if (Files.notExists(launcherProfile.toPath(), new LinkOption[0])) {
            try {
                FileUtil.writeFile(launcherProfile, "{\n\"clientToken\": \"" + this.clientProfile.getClientToken() + "\"\n,\"profiles\": {}}");
            }
            catch (IOException e) {
                this.log(e);
            }
        }
    }

    private void saveProfiles() throws IOException {
        U.log("save profiles");
        this.fileMapperService.write(this.clientProfile, DEFAULT_PROFILE_FILENAME);
    }

    public void print() {
        U.log("accounts");
        this.clientProfile.getAccounts().entrySet().forEach(e -> U.log("" + (String)e.getKey() + " " + ((Account)e.getValue()).getUsername() + " " + ((Account)e.getValue()).getShortUUID() + " " + (Object)((Object)((Account)e.getValue()).getType())));
        U.log("selected " + this.clientProfile.getSelectedAccountUUID());
        U.log("selected free" + this.clientProfile.getFreeAccountUUID());
    }

    public void print1() {
        File f = this.getProfileFile();
        FileOwnerAttributeView ownerInfo = Files.getFileAttributeView(f.toPath(), FileOwnerAttributeView.class, new LinkOption[0]);
        try {
            UserPrincipal fileOwner = ownerInfo.getOwner();
            U.log("File Owned by: " + fileOwner.getName());
            U.log(String.format("read %s, write %s, execute %s", f.canRead(), f.canWrite(), f.canExecute()));
        }
        catch (IOException e) {
            U.log(e);
        }
    }
}

