/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.button;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;

public class StatusStarButton
extends JLabel {
    private boolean status;
    private ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);

    public StatusStarButton(final GameEntityDTO entityDTO, final GameType type) {
        this.setStatus(this.manager.getStatusModpackElement().contains(entityDTO.getId()));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (StatusStarButton.this.status) {
                        StatusStarButton.this.manager.removeStatusElement(entityDTO, type);
                    } else {
                        StatusStarButton.this.manager.addStatusElement(entityDTO, type);
                    }
                }
            }
        });
    }

    public void setStatus(boolean status) {
        this.status = status;
        this.setIcon((Icon)ImageCache.getIcon((String)("star-" + status + ".png")));
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (l instanceof BlockClickListener) {
            return;
        }
        super.addMouseListener(l);
    }
}

