/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.entity.server;

import net.minecraft.common.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.exceptions.ParseException;

public class Server {
    private String name;
    private String address;
    private String ip;
    private String port;
    private boolean hideAddress;
    private int acceptTextures;

    private static String[] splitAddress(String address) {
        String[] array = StringUtils.split((String)address, (char)':');
        switch (array.length) {
            case 1: {
                return new String[]{address, null};
            }
            case 2: {
                return new String[]{array[0], array[1]};
            }
        }
        throw new ParseException("split incorrectly " + address);
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("name", this.name);
        compound.setString("ip", this.address);
        compound.setBoolean("hideAddress", this.hideAddress);
        if (this.acceptTextures != 0) {
            compound.setBoolean("acceptTextures", this.acceptTextures == 1);
        }
        return compound;
    }

    public static Server loadFromNBT(NBTTagCompound nbt) {
        Server server = new Server();
        server.setName(nbt.getString("name"));
        server.setAddress(nbt.getString("ip"));
        server.hideAddress = nbt.getBoolean("hideAddress");
        if (nbt.hasKey("acceptTextures")) {
            server.acceptTextures = nbt.getBoolean("acceptTextures") ? 1 : -1;
        }
        return server;
    }

    public void setAddress(String address) {
        if (address == null) {
            this.ip = null;
            this.port = null;
        } else {
            String[] split = Server.splitAddress(address);
            this.ip = split[0];
            this.port = split[1];
        }
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isHideAddress() {
        return this.hideAddress;
    }

    public int getAcceptTextures() {
        return this.acceptTextures;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setHideAddress(boolean hideAddress) {
        this.hideAddress = hideAddress;
    }

    public void setAcceptTextures(int acceptTextures) {
        this.acceptTextures = acceptTextures;
    }

    public String toString() {
        return "Server(name=" + this.getName() + ", address=" + this.getAddress() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", hideAddress=" + this.isHideAddress() + ", acceptTextures=" + this.getAcceptTextures() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }
}

