/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.Collections;
import net.minecraft.launcher.updater.RepositoryBasedVersionList;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.PartialVersion;
import net.minecraft.launcher.versions.Version;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.Time;
import org.tlauncher.util.TlauncherUtil;

public abstract class UpgratedRepository
extends RepositoryBasedVersionList {
    UpgratedRepository(Repo repo) {
        super(repo);
    }

    @Override
    public VersionList.RawVersionList getRawList() throws IOException {
        Object lock = new Object();
        Time.start(lock);
        VersionList.RawVersionList list = this.gson.fromJson(this.repo.getUrl("version_manifest.json"), VersionList.RawVersionList.class);
        for (PartialVersion partialVersion : list.versions) {
            partialVersion.setVersionList(this);
        }
        this.log("Got in", Time.stop(lock), "ms");
        for (Version version : list.getVersions()) {
            version.setSource(this.repo);
        }
        return list;
    }

    @Override
    public CompleteVersion getCompleteVersion(Version version) throws JsonSyntaxException, IOException {
        if (version instanceof CompleteVersion) {
            return (CompleteVersion)version;
        }
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        String value = ClientInstanceRepo.EMPTY_REPO.getUrl(version.getUrl());
        CompleteVersion complete = this.gson.fromJson(value, CompleteVersion.class);
        TlauncherUtil.processRemoteVersionToSave(complete, value, this.gson);
        complete.getModifiedVersion().setUpdatedTime(version.getUpdatedTime());
        complete.setID(version.getID());
        complete.setVersionList(this);
        complete.setUpdatedTime(version.getUpdatedTime());
        Collections.replaceAll(this.versions, version, complete);
        complete.setSource(this.repo);
        return complete;
    }
}

