/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Desktop;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.U;

public enum OS {
    LINUX("linux", "unix"),
    WINDOWS("win"),
    OSX("mac"),
    SOLARIS("solaris", "sunos"),
    UNKNOWN("unknown");

    public static final String NAME;
    public static final String VERSION;
    public static final double JAVA_VERSION;
    public static final OS CURRENT;
    private static final Map<String, String> systemInfo;
    private final String name;
    private final String[] aliases;
    private static final String[] browsers;

    private OS(String ... aliases) {
        if (aliases == null) {
            throw new NullPointerException();
        }
        this.name = this.toString().toLowerCase(Locale.ROOT);
        this.aliases = aliases;
    }

    private static OS getCurrent() {
        String osName = NAME.toLowerCase(Locale.ROOT);
        for (OS os : OS.values()) {
            for (String alias : os.aliases) {
                if (!osName.contains(alias)) continue;
                return os;
            }
        }
        return UNKNOWN;
    }

    private static double getJavaVersion() {
        int pos;
        String version = System.getProperty("java.version");
        int count = 0;
        for (pos = 0; pos < version.length() && count < 2; ++pos) {
            if (version.charAt(pos) != '.') continue;
            ++count;
        }
        String doubleVersion = version.substring(0, --pos);
        return Double.parseDouble(doubleVersion);
    }

    public static boolean isJava8() {
        return "8".equals(OS.getJavaNumber());
    }

    public static boolean is(OS ... any) {
        if (any == null) {
            throw new NullPointerException();
        }
        if (any.length == 0) {
            return false;
        }
        for (OS compare : any) {
            if (CURRENT != compare) continue;
            return true;
        }
        return false;
    }

    public static String getJavaPathByHome(boolean appendBinFolder) {
        String path = System.getProperty("java.home");
        if (appendBinFolder) {
            path = OS.appendToJVM(path);
        }
        return path;
    }

    public static String appendToJVM(String path) {
        char separator = File.separatorChar;
        StringBuilder b = new StringBuilder(path);
        b.append(separator);
        b.append("bin").append(separator).append("java");
        if (CURRENT == WINDOWS) {
            b.append("w.exe");
        }
        return b.toString();
    }

    public static String appendBootstrapperJvm(String path) {
        StringBuilder b = new StringBuilder();
        if (CURRENT == OSX && !path.toLowerCase().endsWith("jre") && !path.toLowerCase().endsWith("home")) {
            b.append("Contents").append(File.separatorChar).append("Home").append(File.separatorChar).append("jre").append(File.separatorChar);
        }
        return OS.appendToJVM(new File(path, b.toString()).getPath());
    }

    public static String appendBootstrapperJvm1(String path) {
        StringBuilder b = new StringBuilder();
        if (CURRENT == OSX && !path.toLowerCase().endsWith("jre") && !path.toLowerCase().endsWith("home")) {
            b.append("jre.bundle").append(File.separatorChar).append("Contents").append(File.separatorChar).append("Home").append(File.separatorChar);
        }
        return OS.appendToJVM(new File(path, b.toString()).getPath());
    }

    public static String appendBootstrapperJvm2(String path) {
        StringBuilder b = new StringBuilder();
        if (CURRENT == OSX) {
            b.append("Contents").append(File.separatorChar).append("Home").append(File.separatorChar);
        }
        return OS.appendToJVM(new File(path, b.toString()).getPath());
    }

    public static String getSummary() {
        String gpu;
        Configuration c = TLauncher.getInstance().getConfiguration();
        String bitMessage = c.get("memory.problem.message");
        String options = Objects.nonNull(System.getenv("_java_options")) ? System.lineSeparator() + "_java_options " + System.getenv("_java_options") : "";
        StringBuilder builder = new StringBuilder();
        builder.append("-------------------------------------------------------").append(System.lineSeparator());
        builder.append(NAME).append(" ").append(VERSION).append(", Java").append(" ").append(System.getProperty("java.version")).append(", jvm bit ").append((Object)OS.getJavaBit()).append(", ").append(Arch.TOTAL_RAM_MB).append(" MB RAM");
        if (bitMessage != null && Arch.CURRENT == Arch.x32) {
            builder.append(", ").append(bitMessage);
        }
        builder.append(System.lineSeparator());
        builder.append("java path=").append(OS.getJavaPathByHome(true));
        builder.append(options);
        String processInfo = c.get("process.info");
        if (Objects.nonNull(processInfo)) {
            builder.append(System.lineSeparator()).append(processInfo);
        }
        if (Objects.nonNull(gpu = c.get("gpu.info.full"))) {
            builder.append(System.lineSeparator()).append(gpu);
        }
        builder.append(System.lineSeparator()).append("-------------------------------------------------------");
        return builder.toString();
    }

    public static Arch getJavaBit() {
        String res = System.getProperty("sun.arch.data.model");
        if (res != null && res.equalsIgnoreCase("64")) {
            return Arch.x64;
        }
        return Arch.x32;
    }

    private static void rawOpenLink(URI uri) throws Throwable {
        if (!Desktop.isDesktopSupported()) {
            OS.log("Your system doesnt'have a Desktop object");
            return;
        }
        Desktop.getDesktop().browse(uri);
    }

    public static boolean openLink(URI uri, boolean alertError) {
        OS.log("Trying to open link with default browser:", uri);
        try {
            if (OS.is(LINUX)) {
                Runtime.getRuntime().exec("gnome-open " + uri);
                return true;
            }
            if (!Desktop.isDesktopSupported()) {
                OS.log("Your system doesnt'have a Desktop object");
                return false;
            }
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable e) {
            try {
                OS.showDocument(uri.toString());
                return true;
            }
            catch (Throwable t) {
                OS.log("Failed to open link with default browser:", uri, t);
                if (alertError) {
                    SwingUtilities.invokeLater(() -> Alert.showLocError("ui.error.openlink", uri));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean openLink(URI uri) {
        return OS.openLink(uri, true);
    }

    public static boolean openLink(URL url, boolean alertError) {
        OS.log("Trying to open URL with default browser:", url);
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            U.log("error", e);
        }
        return OS.openLink(uri, alertError);
    }

    public static boolean openLink(URL url) {
        return OS.openLink(url, true);
    }

    public static boolean openLink(String url) {
        try {
            return OS.openLink(new URI(url), true);
        }
        catch (URISyntaxException e) {
            U.log(e);
            return false;
        }
    }

    private static void openPath(File path, boolean appendSeparator) throws Throwable {
        String absPath = path.getAbsolutePath() + File.separatorChar;
        Runtime r = Runtime.getRuntime();
        Throwable t = null;
        switch (CURRENT) {
            case OSX: {
                String[] cmdArr = new String[]{"/usr/bin/open", absPath};
                try {
                    r.exec(cmdArr);
                    return;
                }
                catch (Throwable e) {
                    t = e;
                    OS.log("Cannot open folder using:\n", cmdArr, e);
                    break;
                }
            }
            case WINDOWS: {
                String cmd = String.format("cmd.exe /C start \"Open path\" \"%s\"", absPath);
                try {
                    r.exec(cmd);
                    return;
                }
                catch (Throwable e) {
                    t = e;
                    OS.log("Cannot open folder using CMD.exe:\n", cmd, e);
                    break;
                }
            }
            case LINUX: {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(new File(absPath));
                    return;
                }
            }
            default: {
                OS.log("... will use desktop");
            }
        }
        try {
            OS.rawOpenLink(path.toURI());
        }
        catch (Throwable e) {
            t = e;
        }
        if (t == null) {
            return;
        }
        throw t;
    }

    public static boolean openFolder(File folder, boolean alertError) {
        OS.log("Trying to open folder:", folder);
        if (!folder.isDirectory()) {
            OS.log("This path is not a directory, sorry.");
            return false;
        }
        try {
            OS.openPath(folder, true);
        }
        catch (Throwable e) {
            OS.log("Failed to open folder:", e);
            if (alertError) {
                Alert.showLocError("ui.error.openfolder", folder);
            }
            return false;
        }
        return true;
    }

    public static boolean openFolder(File folder) {
        return OS.openFolder(folder, true);
    }

    public static boolean openFile(File file, boolean alertError) {
        OS.log("Trying to open file:", file);
        if (!file.isFile()) {
            OS.log("This path is not a file, sorry.");
            return false;
        }
        try {
            OS.openPath(file, false);
        }
        catch (Throwable e) {
            OS.log("Failed to open file:", e);
            if (alertError) {
                Alert.showLocError("ui.error.openfolder", file);
            }
            return false;
        }
        return true;
    }

    public static boolean openFile(File file) {
        return OS.openFile(file, true);
    }

    protected static void log(Object ... o) {
        U.log("[OS]", o);
    }

    public static String getJavaNumber() {
        if (String.valueOf(JAVA_VERSION).startsWith("10")) {
            return "10";
        }
        if (String.valueOf(JAVA_VERSION).startsWith("11")) {
            return "11";
        }
        if (JAVA_VERSION > 2.0) {
            return String.valueOf(JAVA_VERSION).substring(0, 1);
        }
        return String.valueOf(JAVA_VERSION).substring(2, 3);
    }

    public static void fillSystemInfo() {
        try {
            if (OS.getCurrent() == WINDOWS) {
                Process p = Runtime.getRuntime().exec("cmd.exe /C chcp 437 & systeminfo");
                p.waitFor(30L, TimeUnit.SECONDS);
                String res = FileUtil.readStream(p.getInputStream(), "cp866");
                String[] array = res.split("\r\n");
                for (int i = 0; i < array.length; ++i) {
                    int first;
                    String r = array[i];
                    if (r.isEmpty() || (first = r.indexOf(":")) <= 0) continue;
                    U.debug(r);
                    if (r.substring(0, first).equalsIgnoreCase("Processor(s)")) {
                        systemInfo.put(r.substring(0, first), r.substring(first + 1) + array[++i]);
                        continue;
                    }
                    systemInfo.put(r.substring(0, first), r.substring(first + 1));
                }
            }
        }
        catch (Throwable e) {
            U.log(e);
        }
    }

    public static String executeByTerminal(String command, int time) {
        String res = "";
        try {
            if (OS.getCurrent() == WINDOWS) {
                Process p = Runtime.getRuntime().exec("cmd.exe /C chcp 437 & " + command);
                p.waitFor(time, TimeUnit.SECONDS);
                res = FileUtil.readStream(p.getInputStream(), "IBM437");
            } else if (OS.is(LINUX)) {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor(time, TimeUnit.SECONDS);
                res = FileUtil.readStream(p.getInputStream());
            } else if (OS.is(OSX)) {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor(time, TimeUnit.SECONDS);
                res = FileUtil.readStream(p.getInputStream());
            }
        }
        catch (Throwable e) {
            OS.log(e);
        }
        return res;
    }

    public static String executeByTerminal(String command) {
        return OS.executeByTerminal(command, 30);
    }

    public static String getSystemInfo(String key) {
        return systemInfo.get(key);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnsupported() {
        return this == UNKNOWN;
    }

    public boolean isCurrent() {
        return this == CURRENT;
    }

    private static void showDocument(String var1) {
        try {
            if (OS.is(OSX)) {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, var1);
            } else if (OS.is(WINDOWS)) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + var1);
            } else {
                String var3 = null;
                for (String var7 : browsers) {
                    if (var3 != null || Runtime.getRuntime().exec(new String[]{"which", var7}).getInputStream().read() == -1) continue;
                    Runtime var10000 = Runtime.getRuntime();
                    String[] var10001 = new String[2];
                    var3 = var7;
                    var10001[0] = var7;
                    var10001[1] = var1;
                    var10000.exec(var10001);
                }
                if (var3 == null) {
                    throw new Exception("No web browser found");
                }
            }
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
    }

    public static String buildJVMKey() {
        StringBuilder b = new StringBuilder();
        switch (CURRENT) {
            case WINDOWS: 
            case LINUX: {
                b.append(OS.CURRENT.name);
                break;
            }
            case OSX: {
                b.append("mac-os");
            }
        }
        switch (Arch.CURRENT) {
            case x32: {
                if (CURRENT.equals((Object)LINUX)) {
                    b.append("-i386");
                    break;
                }
                if (!CURRENT.equals((Object)WINDOWS)) break;
                b.append("-x86");
                break;
            }
            case x64: {
                if (!CURRENT.equals((Object)WINDOWS)) break;
                b.append("-x64");
                break;
            }
        }
        return b.toString();
    }

    public static Path buildJAVAFolder() {
        Path p = null;
        switch (CURRENT) {
            case WINDOWS: {
                switch (Arch.CURRENT) {
                    case x32: {
                        p = Paths.get("C:\\Program Files (x86)\\Java", new String[0]);
                        break;
                    }
                    case x64: {
                        p = Paths.get("C:\\Program Files\\Java", new String[0]);
                    }
                }
                break;
            }
            case LINUX: {
                p = Paths.get("/usr/lib/jvm", new String[0]);
                break;
            }
            case OSX: {
                p = Paths.get("/Library/Java/JavaVirtualMachines", new String[0]);
            }
        }
        if (Files.notExists(p, new LinkOption[0]) || Objects.isNull(p)) {
            return Paths.get(".", new String[0]);
        }
        return p;
    }

    static {
        NAME = System.getProperty("os.name");
        VERSION = System.getProperty("os.version");
        JAVA_VERSION = OS.getJavaVersion();
        CURRENT = OS.getCurrent();
        systemInfo = new HashMap<String, String>();
        browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "mozilla"};
    }

    public static enum Arch {
        x32,
        x64,
        UNKNOWN;

        public static final Arch CURRENT;
        public static final long TOTAL_RAM;
        public static final int TOTAL_RAM_MB;
        public static final int MIN_MEMORY = 512;
        public static final int MAX_MEMORY;
        public static final int PREFERRED_MEMORY;
        private final String asString = this.toString().substring(1);
        private final int asInt;

        private Arch() {
            int asInt_temp = 0;
            try {
                asInt_temp = Integer.parseInt(this.asString);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.asInt = asInt_temp;
        }

        private static Arch getCurrent() {
            String curArch = System.getProperty("sun.arch.data.model");
            for (Arch arch : Arch.values()) {
                if (!arch.asString.equals(curArch)) continue;
                return arch;
            }
            return UNKNOWN;
        }

        private static long getTotalRam() {
            long m = 0L;
            try {
                m = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
            }
            catch (Throwable e) {
                U.log("[ERROR] Cannot allocate total physical memory size!", e);
            }
            finally {
                if (m == 0L) {
                    m = 10000000000L;
                }
            }
            return m;
        }

        private static int getPreferWrapper() {
            switch (CURRENT) {
                case x64: {
                    if (TOTAL_RAM_MB > 6000) {
                        return 3000;
                    }
                    if (TOTAL_RAM_MB > 3000) {
                        return TOTAL_RAM_MB - 1024;
                    }
                    if (TOTAL_RAM_MB > 2000) {
                        return TOTAL_RAM_MB - 512;
                    }
                    return TOTAL_RAM_MB;
                }
                case x32: {
                    if (TOTAL_RAM_MB > 1500) {
                        return 1500;
                    }
                    if (TOTAL_RAM_MB <= 1024) break;
                    return 750;
                }
            }
            return 512;
        }

        private static int getMaximumMemory() {
            switch (CURRENT) {
                case x64: {
                    return TOTAL_RAM_MB;
                }
                case x32: {
                    if (TOTAL_RAM_MB <= 1500) break;
                    return 1024;
                }
            }
            return 512;
        }

        public String asString() {
            return this == UNKNOWN ? this.toString() : this.asString;
        }

        public int asInteger() {
            return this.asInt;
        }

        public boolean isCurrent() {
            return this == CURRENT;
        }

        static {
            CURRENT = Arch.getCurrent();
            TOTAL_RAM = Arch.getTotalRam();
            TOTAL_RAM_MB = (int)(TOTAL_RAM / 1024L / 1024L);
            MAX_MEMORY = Arch.getMaximumMemory();
            PREFERRED_MEMORY = Arch.getPreferWrapper();
        }
    }
}

