/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;

public class UpdaterFullButton
extends UpdaterButton {
    private static final long serialVersionUID = 992760417140310208L;
    protected Color unEnableColor;
    protected Color backgroundColor;
    private Image image;
    private Image imageUp;

    public UpdaterFullButton(Color color, String value, String image) {
        super(color, value);
        this.backgroundColor = color;
        this.image = ImageCache.getImage((String)image);
        this.setForeground(Color.WHITE);
        this.setHorizontalTextPosition(4);
    }

    public UpdaterFullButton(Color color, final Color mouseUnder, String value, String image) {
        super(color, value);
        this.setHorizontalTextPosition(4);
        this.backgroundColor = color;
        this.image = ImageCache.getImage((String)image);
        this.setForeground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                UpdaterFullButton.this.setBackground(mouseUnder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                UpdaterFullButton.this.setBackground(UpdaterFullButton.this.backgroundColor);
            }
        });
    }

    public UpdaterFullButton(Color color, final Color mouseUnder, String value, String image, String imageUp) {
        super(color, value);
        this.setHorizontalTextPosition(4);
        this.backgroundColor = color;
        this.image = ImageCache.getImage((String)image);
        this.imageUp = ImageCache.getImage((String)imageUp);
        this.setForeground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                UpdaterFullButton.this.setBackground(mouseUnder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                UpdaterFullButton.this.setBackground(UpdaterFullButton.this.backgroundColor);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle rec = this.getVisibleRect();
        String text = this.getText();
        UpdaterFullButton component = this;
        this.paintBackground(rec, g);
        this.paintText(g, component, rec, text);
        this.paintPicture(g, component, rec, this.getModel().isRollover());
    }

    protected void paintPicture(Graphics g, JComponent c, Rectangle rect, boolean rollover) {
        if (this.image == null) {
            return;
        }
        if (this.getHorizontalTextPosition() == 4) {
            Graphics2D g2d = (Graphics2D)g;
            int x = this.getInsets().left;
            int y = (this.getHeight() - this.image.getHeight(null)) / 2;
            if (rollover && this.imageUp != null) {
                g2d.drawImage(this.imageUp, x, y, null);
            } else {
                g2d.drawImage(this.image, x, y, null);
            }
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (text == null) {
            return;
        }
        if (this.getHorizontalTextPosition() == 4) {
            g.setColor(this.getForeground());
            Graphics2D g2d = (Graphics2D)g;
            g2d.setFont(this.getFont());
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(text, g2d);
            int x = this.getInsets().left + this.image.getWidth(null) + this.getIconTextGap();
            int y = (this.getHeight() - (int)r.getHeight()) / 2 + fm.getAscent() - 1;
            g2d.drawString(text, x, y);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    protected void paintBackground(Rectangle rec, Graphics g) {
        ButtonModel buttonModel = this.getModel();
        g.setColor(this.getBackground());
        if (buttonModel.isPressed()) {
            g.setColor(this.getBackground());
            g.fillRect(rec.x, rec.y, rec.width, rec.height);
        } else if (!buttonModel.isEnabled()) {
            if (this.unEnableColor == null) {
                g.setColor(this.getForeground().darker());
            } else {
                g.setColor(this.unEnableColor);
            }
        } else if (buttonModel.isRollover()) {
            g.setColor(this.unEnableColor);
        }
        g.fillRect(rec.x, rec.y, rec.width, rec.height);
    }
}

