/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.versions;

import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.images.ImageIcon;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.swing.VersionCellRenderer;
import org.tlauncher.tlauncher.ui.swing.border.VersionBorder;
import org.tlauncher.tlauncher.ui.versions.VersionHandler;
import org.tlauncher.tlauncher.ui.versions.VersionList;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public class VersionListCellRenderer
extends VersionCellRenderer {
    private final VersionHandler handler;
    private final ImageIcon downloading;
    private static final Color FOREGROUND_COLOR = new Color(76, 75, 74);
    private static final Color BACKGROUND_COLOR = new Color(235, 235, 235);

    VersionListCellRenderer(VersionList list) {
        this.handler = list.handler;
        this.downloading = ImageCache.getIcon((String)"down.png", (int)16, (int)16);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends VersionSyncInfo> list, VersionSyncInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label;
        block5: {
            Iterator<VersionSyncInfo> iterator;
            if (value == null) {
                return null;
            }
            label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!isSelected) {
                if (value.isInstalled()) {
                    label.setBackground(Color.WHITE);
                } else {
                    label.setBackground(BACKGROUND_COLOR);
                }
            }
            SwingUtil.changeFontFamily(label, FontTL.ROBOTO_BOLD, 14, FOREGROUND_COLOR);
            label.setBorder(new VersionBorder(10, 20, 10, 0, VersionBorder.SEPARATOR_COLOR));
            if (value.isInstalled() && !value.isUpToDate()) {
                label.setText(label.getText() + ' ' + Localizable.get("version.list.needsupdate"));
            }
            if (this.handler.downloading == null || !(iterator = this.handler.downloading.iterator()).hasNext()) break block5;
            VersionSyncInfo compare = iterator.next();
            ImageIcon icon = compare.equals(value) ? this.downloading : null;
            label.setIcon((Icon)icon);
            label.setDisabledIcon((Icon)icon);
        }
        return label;
    }
}

