/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Locale;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.editor.EditorPane;
import org.tlauncher.util.OS;

public class AccountTip
extends CenterPanel
implements LocalizableComponent {
    public static final int WIDTH = 510;
    public final Tip mojangTip;
    public final Tip tlauncherTip;
    public final Tip microsoftTip;
    public final Tip freeTip;
    private final AccountEditorScene scene;
    private Tip tip;
    private final EditorPane content;

    public AccountTip(AccountEditorScene sc) {
        super(smallSquareInsets);
        this.scene = sc;
        this.content = new EditorPane();
        this.content.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!AccountTip.this.isVisible()) {
                    e.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!AccountTip.this.isVisible()) {
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!AccountTip.this.isVisible()) {
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!AccountTip.this.isVisible()) {
                    e.consume();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!AccountTip.this.isVisible()) {
                    e.consume();
                }
            }
        });
        this.add((Component)this.content);
        this.freeTip = new Tip(Account.AccountType.FREE, ImageCache.getRes((String)"free-user.png"));
        this.mojangTip = new Tip(Account.AccountType.MOJANG, ImageCache.getRes((String)"mojang-user.png"));
        this.tlauncherTip = new Tip(Account.AccountType.TLAUNCHER, ImageCache.getRes((String)"tlauncher-user.png"));
        this.microsoftTip = new Tip(Account.AccountType.MICROSOFT, ImageCache.getRes((String)"microsoft-user.png"));
        this.setTip(null);
    }

    public void setAccountType(Account.AccountType type) {
        if (type != null) {
            switch (type) {
                case TLAUNCHER: {
                    this.setTip(this.tlauncherTip);
                    return;
                }
                case FREE: {
                    this.setTip(this.freeTip);
                    return;
                }
                case MOJANG: {
                    this.setTip(this.mojangTip);
                    return;
                }
                case MICROSOFT: {
                    this.setTip(this.microsoftTip);
                    return;
                }
            }
        }
        this.setTip(null);
    }

    public Tip getTip() {
        return this.tip;
    }

    public void setTip(Tip tip) {
        this.tip = tip;
        if (tip == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        StringBuilder builder = new StringBuilder();
        builder.append("<table width=\"").append(510 - this.getInsets().left - this.getInsets().right).append("\" height=\"").append(tip.getHeight()).append("\"><tr><td align=\"center\" valign=\"center\">");
        if (tip.image != null) {
            builder.append("<img src=\"").append(tip.image).append("\" /></td><td align=\"center\" valign=\"center\" width=\"100%\">");
        }
        builder.append(Localizable.get(tip.path));
        builder.append("</td></tr></table>");
        this.setContent(builder.toString(), 510, tip.getHeight());
    }

    void setContent(String text, int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException();
        }
        this.content.setText(text);
        if (OS.CURRENT == OS.LINUX) {
            width = (int)((double)width * 1.2);
            height = (int)((double)height * 1.2);
        }
        this.setSize(width, height + this.getInsets().top + this.getInsets().bottom);
    }

    @Override
    public void updateLocale() {
        this.setTip(this.tip);
    }

    public class Tip {
        private final Account.AccountType type;
        private final String path;
        private final URL image;

        Tip(Account.AccountType type, URL image) {
            this.type = type;
            this.path = "auth.tip." + type.toString().toLowerCase(Locale.ROOT);
            this.image = image;
        }

        public int getHeight() {
            return AccountTip.this.tlauncher.getLang().getInteger(this.path + ".height");
        }
    }
}

