/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.user;

import java.util.Objects;
import java.util.UUID;
import org.tlauncher.tlauncher.minecraft.user.LoginCredentials;
import org.tlauncher.tlauncher.minecraft.user.MicrosoftOAuthToken;
import org.tlauncher.tlauncher.minecraft.user.User;
import org.tlauncher.tlauncher.minecraft.user.mcsauth.MinecraftServicesToken;
import org.tlauncher.tlauncher.minecraft.user.preq.MinecraftOAuthProfile;

public class MinecraftUser
extends User {
    public static final String TYPE = "minecraft";
    private MinecraftOAuthProfile profile;
    private MicrosoftOAuthToken microsoftToken;
    private MinecraftServicesToken minecraftToken;

    public MinecraftUser(MinecraftOAuthProfile profile, MicrosoftOAuthToken microsoftToken, MinecraftServicesToken minecraftToken) {
        this.setPayload(profile, microsoftToken, minecraftToken);
    }

    @Override
    public String getUsername() {
        return this.profile.getName();
    }

    @Override
    public String getDisplayName() {
        return this.profile.getName();
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    public MicrosoftOAuthToken getMicrosoftToken() {
        return this.microsoftToken;
    }

    void setMicrosoftToken(MicrosoftOAuthToken microsoftToken) {
        this.microsoftToken = Objects.requireNonNull(microsoftToken, "microsoftToken");
    }

    public MinecraftServicesToken getMinecraftToken() {
        return this.minecraftToken;
    }

    void setMinecraftToken(MinecraftServicesToken minecraftToken) {
        this.minecraftToken = Objects.requireNonNull(minecraftToken, "minecraftToken");
    }

    void setPayload(MinecraftOAuthProfile profile, MicrosoftOAuthToken microsoftToken, MinecraftServicesToken minecraftToken) {
        this.setProfile(profile);
        this.setMicrosoftToken(microsoftToken);
        this.setMinecraftToken(minecraftToken);
    }

    void setProfile(MinecraftOAuthProfile profile) {
        this.profile = Objects.requireNonNull(profile, "profile");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equals(User user) {
        return user != null && this.profile.getId().equals(((MinecraftUser)user).profile.getId());
    }

    @Override
    public int hashCode() {
        int result = this.profile.hashCode();
        result = 31 * result + this.microsoftToken.hashCode();
        return 31 * result + this.minecraftToken.hashCode();
    }

    @Override
    public LoginCredentials getLoginCredentials() {
        return new LoginCredentials(this.profile.getName(), this.minecraftToken.getAccessToken(), "{}", this.profile.getName(), this.profile.getId(), "mojang", this.profile.getName());
    }
}

