/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.component.ComponentDependence;
import org.tlauncher.tlauncher.component.LauncherComponent;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.managers.VersionLists;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;

@ComponentDependence(value={VersionManager.class, VersionLists.class})
public class AssetsManager
extends LauncherComponent {
    private final Gson gson = TLauncher.getGson();
    private final Object assetsFlushLock = new Object();

    public AssetsManager(ComponentManager manager) throws Exception {
        super(manager);
    }

    public DownloadableContainer downloadResources(CompleteVersion version, List<AssetIndex.AssetObject> list, boolean force) {
        File baseDirectory = this.manager.getLauncher().getVersionManager().getLocalList().getBaseDirectory();
        DownloadableContainer container = new DownloadableContainer();
        container.addAll(AssetsManager.getResourceFiles(version, baseDirectory, list));
        return container;
    }

    private static Set<Downloadable> getResourceFiles(CompleteVersion version, File baseDirectory, List<AssetIndex.AssetObject> list) {
        HashSet<Downloadable> result = new HashSet<Downloadable>();
        File objectsFolder = new File(baseDirectory, "assets/objects");
        for (AssetIndex.AssetObject object : list) {
            String filename = object.getFilename();
            MetadataDTO metadataDTO = new MetadataDTO();
            metadataDTO.setUrl(filename);
            metadataDTO.setPath(filename);
            metadataDTO.setSha1(object.getHash());
            metadataDTO.setSize(object.getSize());
            metadataDTO.setLocalDestination(new File(objectsFolder, filename));
            Downloadable d = new Downloadable(ClientInstanceRepo.ASSETS_REPO, metadataDTO, false, true);
            result.add(d);
        }
        return result;
    }

    private List<AssetIndex.AssetObject> getResourceFiles(CompleteVersion version, File baseDirectory, boolean local) {
        List<AssetIndex.AssetObject> list = null;
        if (!local) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception e) {
                this.log("Cannot get remote assets list. Trying to use the local one.", e);
            }
        }
        if (list == null) {
            list = this.getLocalResourceFilesList(version, baseDirectory);
        }
        if (list == null) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception e) {
                this.log("Gave up trying to get assets list.", e);
            }
        }
        return list;
    }

    private List<AssetIndex.AssetObject> getLocalResourceFilesList(CompleteVersion version, File baseDirectory) {
        String json;
        long size;
        String indexName = version.getAssets();
        File indexesFolder = new File(baseDirectory, "assets/indexes/");
        File indexFile = new File(indexesFolder, indexName + ".json");
        if (Objects.nonNull(version.getAssetIndex()) && (size = version.getAssetIndex().getSize()) != 0L && version.getID().equals("1.14") && indexFile.length() != size) {
            this.log("not new assets index file");
            return null;
        }
        this.log("Reading indexes from file", indexFile);
        try {
            json = FileUtil.readFile(indexFile);
        }
        catch (Exception e) {
            this.log("Cannot read local resource files list for index:", indexName, e);
            return null;
        }
        AssetIndex index = null;
        try {
            index = this.gson.fromJson(json, AssetIndex.class);
        }
        catch (JsonSyntaxException e) {
            this.log("JSON file is invalid", e);
        }
        if (index == null) {
            this.log("Cannot read data from JSON file.");
            return null;
        }
        return Lists.newArrayList(index.getUniqueObjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssetIndex.AssetObject> getRemoteResourceFilesList(CompleteVersion version, File baseDirectory, boolean save) throws IOException {
        String indexName = version.getAssets();
        if (indexName == null) {
            indexName = "legacy";
        }
        File assets = new File(baseDirectory, "assets");
        File indexesFolder = new File(assets, "indexes");
        File indexFile = new File(indexesFolder, indexName + ".json");
        this.log("Reading from repository...");
        String json = version.getAssetIndex() != null ? ClientInstanceRepo.EMPTY_REPO.getUrl(version.getAssetIndex().getUrl()) : ClientInstanceRepo.OFFICIAL_VERSION_REPO.getUrl("indexes/" + indexName + ".json");
        if (save) {
            Object object = this.assetsFlushLock;
            synchronized (object) {
                FileUtil.writeFile(indexFile, json);
            }
        }
        return Lists.newArrayList(this.gson.fromJson(json, AssetIndex.class).getUniqueObjects());
    }

    private List<AssetIndex.AssetObject> checkResources(CompleteVersion version, File baseDirectory, boolean fast) {
        this.log("Checking resources...");
        ArrayList<AssetIndex.AssetObject> r = new ArrayList<AssetIndex.AssetObject>();
        List<AssetIndex.AssetObject> list = this.getResourceFiles(version, baseDirectory, fast);
        if (list == null) {
            this.log("Cannot get assets list. Aborting.");
            return r;
        }
        this.log("Fast comparing:", fast);
        for (AssetIndex.AssetObject resource : list) {
            if (AssetsManager.checkResource(baseDirectory, resource, fast)) continue;
            r.add(resource);
        }
        return r;
    }

    public List<AssetIndex.AssetObject> checkResources(CompleteVersion version, boolean fast) {
        return this.checkResources(version, this.manager.getComponent(VersionLists.class).getLocal().getBaseDirectory(), fast);
    }

    private static boolean checkResource(File baseDirectory, AssetIndex.AssetObject local, boolean fast) {
        String path = local.getFilename();
        File file = new File(baseDirectory, "assets/objects/" + path);
        long size = file.length();
        if (!file.isFile() || size == 0L) {
            return false;
        }
        if (fast) {
            return true;
        }
        if (local.getHash() == null) {
            return true;
        }
        return local.getHash().equals(FileUtil.getChecksum(file));
    }
}

