/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Paths;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.DownloaderListener;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.progress.login.LauncherProgress;
import org.tlauncher.tlauncher.ui.progress.login.LauncherProgressListener;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.MinecraftUtil;

public class ProgressBarPanel
extends JLayeredPane
implements LocalizableComponent,
DownloaderListener,
MinecraftExtendedListener,
LauncherProgressListener,
LoginProcessListener {
    private static final long serialVersionUID = 4005627356304541408L;
    public static final Dimension SIZE = new Dimension(1050, 24);
    private final JLabel percentLabel;
    private final JLabel centerLabel;
    private final JLabel speedLabel;
    private final JLabel fileLabel;
    private final ExtendedPanel upperPanel;
    private JProgressBar bar;
    private boolean downloadingStart;

    public ProgressBarPanel(Icon speed, Icon file, LauncherProgress bar) {
        this.bar = bar;
        this.setVisible(false);
        this.upperPanel = new ExtendedPanel(new BorderLayout(0, 0));
        this.speedLabel = this.createLabel(speed);
        this.speedLabel.setHorizontalTextPosition(4);
        this.fileLabel = this.createLabel(file);
        this.fileLabel.setHorizontalTextPosition(4);
        this.percentLabel = this.createLabel(null);
        this.centerLabel = this.createLabel(null);
        this.centerLabel.setHorizontalAlignment(0);
        this.percentLabel.setFont(this.percentLabel.getFont().deriveFont(1));
        this.upperPanel.setPreferredSize(SIZE);
        this.upperPanel.setInsets(0, 20, 0, 20);
        this.setPreferredSize(SIZE);
        ExtendedPanel leftPanel = new ExtendedPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 0));
        leftPanel.add((Component)this.speedLabel);
        leftPanel.add(Box.createHorizontalStrut(20));
        leftPanel.add((Component)this.fileLabel);
        this.upperPanel.add((Component)this.centerLabel, "Center");
        this.upperPanel.add((Component)this.percentLabel, "East");
        this.upperPanel.add((Component)leftPanel, "West");
        this.add((Component)bar, 1);
        this.add((Component)this.upperPanel, 0);
        bar.setBounds(0, 0, ProgressBarPanel.SIZE.width, ProgressBarPanel.SIZE.height);
        this.upperPanel.setBounds(0, 0, ProgressBarPanel.SIZE.width, ProgressBarPanel.SIZE.height);
    }

    private JLabel createLabel(Icon icon) {
        JLabel jLabel = new JLabel();
        jLabel.setFont(jLabel.getFont().deriveFont(0, 12.0f));
        if (icon != null) {
            jLabel.setIcon(icon);
        }
        jLabel.setHorizontalTextPosition(4);
        return jLabel;
    }

    private void startProgress() {
        this.clean();
        this.centerLabel.setText(Localizable.get("progress.bar.panel.init"));
        this.downloadingStart = true;
        this.setVisible(true);
    }

    private void stopProgress() {
        this.clean();
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.startProgress();
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed, double remainedData) {
        this.updateStateDownloading(d, progress, speed, remainedData);
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
        this.updateStateDownloading(d, d.getProgress(), d.getSpeed(), d.getRemainedData());
    }

    private void updateStateDownloading(Downloader d, double progress, double speed, double remainedData) {
        int remainingTime = (int)(remainedData / speed);
        this.bar.setValue((int)progress);
        StringBuilder b = new StringBuilder();
        b.append(Localizable.get("progress.bar.panel.file.remained")).append(" ").append(d.getRemaining()).append(" ").append(Localizable.get("progress.bar.panel.file")).append(" ").append((int)Math.ceil(remainedData)).append(" ").append(Localizable.get("progress.bar.panel.size")).append(", ").append(Localizable.get("progress.bar.panel.remaining.time")).append(" ");
        if (remainingTime < 60) {
            b.append(Localizable.get("progress.bar.panel.remaining.time.less.than.minute"));
        } else {
            b.append((int)Math.ceil((double)remainingTime / 60.0)).append(" ").append(Localizable.get("progress.bar.panel.remaining.time.minutes"));
        }
        this.fileLabel.setText(b.toString());
        b.setLength(0);
        b.append(Localizable.get("progress.bar.panel.speed"));
        if (speed < 1.0) {
            b.append(" ").append(String.format("%.2f", speed *= 1024.0)).append(" ").append(Localizable.get("progress.bar.panel.speed.unity.KB"));
        } else {
            b.append(" ").append(String.format("%.2f", speed)).append(" ").append(Localizable.get("progress.bar.panel.speed.unity.MB"));
        }
        this.speedLabel.setText(b.toString());
        this.percentLabel.setText((int)progress + "%");
        if (this.downloadingStart) {
            this.centerLabel.setVisible(false);
            this.fileLabel.setVisible(true);
            this.speedLabel.setVisible(true);
            this.downloadingStart = false;
        }
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftPrepare() {
        this.startProgress();
        this.centerLabel.setVisible(true);
    }

    @Override
    public void onMinecraftAbort() {
        this.stopProgress();
    }

    @Override
    public void onMinecraftClose() {
    }

    @Override
    public void onMinecraftError(Throwable e) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
    }

    @Override
    public void onMinecraftCollecting() {
    }

    @Override
    public void onMinecraftComparingAssets() {
    }

    @Override
    public void onMinecraftDownloading() {
    }

    @Override
    public void onMinecraftReconstructingAssets() {
    }

    @Override
    public void onMinecraftUnpackingNatives() {
    }

    @Override
    public void onMinecraftDeletingEntries() {
    }

    @Override
    public void onMinecraftConstructing() {
    }

    @Override
    public void onMinecraftLaunch() {
        this.stopProgress();
    }

    @Override
    public void onMinecraftPostLaunch() {
    }

    @Override
    public void onWorldBackup() {
        this.centerLabel.setText(Localizable.get("settings.backup.process").concat(" ").concat(String.valueOf(Paths.get(MinecraftUtil.getWorkingDirectory().toString(), "backup/saves"))));
    }

    private void clean() {
        this.speedLabel.setVisible(false);
        this.fileLabel.setVisible(false);
        this.speedLabel.setText("");
        this.fileLabel.setText("");
        this.percentLabel.setText("");
        this.bar.setValue(0);
        this.setVisible(false);
    }

    public JProgressBar getBar() {
        return this.bar;
    }

    public void setBar(JProgressBar bar) {
        this.bar = bar;
    }

    @Override
    public void repaintPanel() {
        this.upperPanel.repaint();
    }

    @Override
    public void preValidate() throws LoginException {
        SwingUtilities.invokeLater(() -> {
            this.clean();
            this.centerLabel.setText(Localizable.get("progress.bar.panel.validate.account.token"));
            this.downloadingStart = true;
            this.setVisible(true);
        });
    }

    @Override
    public void loginFailed() {
        SwingUtilities.invokeLater(() -> this.stopProgress());
    }
}

