/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.center.LoginHelperTheme;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.scenes.DefaultScene;
import org.tlauncher.tlauncher.ui.swing.ResizeableComponent;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.SwingUtil;

public class LoginFormHelper
extends ExtendedLayeredPane
implements LocalizableComponent {
    private static final int EDGE = 100;
    private final DefaultScene defaultScene;
    private final LoginForm loginForm;
    private final LoginFormHelperTip[] tips;
    private volatile LoginFormHelperState state;
    private static final LoginHelperTheme loginHelperTheme = new LoginHelperTheme();
    private static final Insets loginHelperInsets = new Insets(6, 10, 6, 10);

    public LoginFormHelper(DefaultScene scene) {
        this.defaultScene = scene;
        this.loginForm = scene.loginForm;
        for (LoginFormHelperTip tip : this.tips = new LoginFormHelperTip[]{new LoginFormHelperTip("username", this.loginForm.accountPanel, Position.UP), new LoginFormHelperTip("versions", this.loginForm.versionPanel, Position.UP), new LoginFormHelperTip("play", this.loginForm.playPanel, Position.UP)}) {
            tip.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoginFormHelper.this.setState(LoginFormHelperState.NONE);
                }
            });
        }
        this.add(this.tips);
        this.setState(LoginFormHelperState.NONE);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LoginFormHelper.this.setState(LoginFormHelperState.NONE);
            }
        };
        this.loginForm.play.addMouseListener(adapter);
        this.loginForm.buttons.refresh.addMouseListener(adapter);
        this.loginForm.buttons.folder.addMouseListener(adapter);
        this.loginForm.buttons.settings.addMouseListener(adapter);
    }

    public LoginFormHelperState getState() {
        return this.state;
    }

    public void setState(LoginFormHelperState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.updateTips();
        this.setVisible(state != LoginFormHelperState.NONE);
    }

    @Override
    public void onResize() {
        this.setSize(this.loginForm.getWidth(), 100);
        this.setLocation(this.loginForm.getX(), this.loginForm.getY() - 100);
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof ResizeableComponent)) continue;
            ((ResizeableComponent)((Object)comp)).onResize();
        }
        this.updateTips();
    }

    protected void updateTips() {
        for (LoginFormHelperTip tip : this.tips) {
            tip.setVisible(false);
            if (this.state == LoginFormHelperState.NONE) continue;
            tip.label.setText("loginform.helper." + tip.name);
            tip.label.setVerticalAlignment(0);
            tip.label.setHorizontalAlignment(0);
            Dimension dim = tip.getPreferredSize();
            Point pP = SwingUtil.getRelativeLocation(this.loginForm, tip.component);
            int x = pP.x - dim.width + tip.component.getPreferredSize().width;
            int y = 100 - dim.height;
            tip.setBounds(x, y, dim.width, dim.height);
            tip.setVisible(true);
        }
    }

    @Override
    public void updateLocale() {
        this.updateTips();
    }

    public static enum BORDER_POS {
        UP,
        BOTTOM,
        LEFT,
        RIGHT;

    }

    class TipTriangle
    extends ExtendedPanel {
        public static final int DEFAULT_WIDTH = 10;
        private int width;
        private int gap = 24;
        private final BORDER_POS pos;
        private Color triangleColor;

        public TipTriangle(int width, Color triangle, BORDER_POS pos) {
            this.width = width;
            this.pos = pos;
            this.triangleColor = triangle;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setColor(this.triangleColor);
            Rectangle rec = this.getVisibleRect();
            int[] xT = new int[]{};
            int[] yT = new int[]{};
            int startX = rec.x + rec.width + -this.gap;
            int startY = rec.y;
            xT = new int[]{startX, startX - this.width, startX - this.width * 2};
            yT = new int[]{startY, startY + this.width, startY};
            g2.fillPolygon(xT, yT, 3);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
        }
    }

    private class LoginFormHelperTip
    extends CenterPanel {
        private static final int TRIANGGLE_WIDTH = 10;
        final String name;
        final JComponent component;
        final LocalizableLabel label;

        LoginFormHelperTip(String name, JComponent comp, Position pos) {
            super(loginHelperTheme, noInsets);
            this.setLayout(new BorderLayout(0, 0));
            if (name == null) {
                throw new NullPointerException("Name is NULL!");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name is empty!");
            }
            if (comp == null) {
                throw new NullPointerException("Component is NULL!");
            }
            if (pos == null) {
                throw new NullPointerException("Position is NULL!");
            }
            this.name = name.toLowerCase();
            this.component = comp;
            ExtendedPanel p = new ExtendedPanel(new BorderLayout(0, 0));
            p.setInsets(loginHelperInsets);
            p.setOpaque(true);
            p.setBackground(loginHelperTheme.getBackground());
            this.label = new LocalizableLabel();
            this.label.setFont(new Font(this.label.getFont().getFamily(), 0, 12));
            this.label.setForeground(loginHelperTheme.getForeground());
            p.add((Component)this.label, "Center");
            this.add((Component)p, "Center");
            this.add((Component)new TipTriangle(10, loginHelperTheme.getBorder(), BORDER_POS.UP), "South");
        }
    }

    public static enum Position {
        UP,
        DOWN;

    }

    public static enum LoginFormHelperState {
        NONE,
        SHOWN;

    }
}

