/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tlauncher.tlauncher.component.LauncherComponent;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.managers.ComponentManagerListener;
import org.tlauncher.tlauncher.managers.TLauncherManager;
import org.tlauncher.tlauncher.managers.TlauncherManagerListener;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.Blocker;

public class ComponentManagerListenerHelper
extends LauncherComponent
implements Blockable,
VersionManagerListener,
TlauncherManagerListener {
    private final List<ComponentManagerListener> listeners = Collections.synchronizedList(new ArrayList());

    public ComponentManagerListenerHelper(ComponentManager manager) throws Exception {
        super(manager);
        manager.getComponent(VersionManager.class).addListener(this);
    }

    public void addListener(ComponentManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
        Blocker.block(this, manager);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        Blocker.unblock(this, manager);
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        Blocker.unblock(this, manager);
    }

    @Override
    public void block(Object reason) {
        for (ComponentManagerListener listener : this.listeners) {
            listener.onComponentsRefreshing(this.manager);
        }
    }

    @Override
    public void unblock(Object reason) {
        for (ComponentManagerListener listener : this.listeners) {
            listener.onComponentsRefreshed(this.manager);
        }
    }

    @Override
    public void onTlauncherUpdating(TLauncherManager manager) {
        Blocker.block(this, manager);
    }

    @Override
    public void onTlauncherUpdated(TLauncherManager manager) {
        Blocker.unblock(this, manager);
    }
}

