/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.tlauncher.tlauncher.ui.loc.LocalizableRadioButton;

public class GameRadioButton
extends LocalizableRadioButton {
    private Color selected = new Color(60, 170, 232);
    private Color under = new Color(255, 202, 41);
    private boolean mouseUnder = false;

    public GameRadioButton(String string) {
        super(string);
        this.setPreferredSize(new Dimension(149, 52));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GameRadioButton.this.mouseUnder = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GameRadioButton.this.mouseUnder = false;
            }
        });
        this.setForeground(Color.BLACK);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y;
        super.paintComponent(g);
        Rectangle rec = this.getVisibleRect();
        int i = 242;
        Graphics2D g2 = (Graphics2D)g;
        for (y = rec.y; y < rec.height + rec.y; ++y) {
            g2.setColor(new Color(i, i, i));
            if (i != 255) {
                ++i;
            }
            g2.drawLine(rec.x, y, rec.x + rec.width, y);
        }
        if (this.isSelected()) {
            g2.setColor(this.selected);
            for (y = rec.y + rec.height - 3; y < rec.height + rec.y; ++y) {
                g2.drawLine(rec.x, y, rec.x + rec.width, y);
            }
        } else if (this.mouseUnder) {
            g2.setColor(this.under);
            for (y = rec.y + rec.height - 3; y < rec.height + rec.y; ++y) {
                g2.drawLine(rec.x, y, rec.x + rec.width, y);
            }
        }
        this.paintText(g2, rec);
    }

    protected void paintText(Graphics2D g, Rectangle textRect) {
        g.setColor(this.getForeground());
        String text = this.getText();
        Graphics2D g2d = g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(text, g2d);
        g.setFont(this.getFont());
        int x = (this.getWidth() - (int)r.getWidth()) / 2;
        int y = (this.getHeight() - (int)r.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, x, y);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }
}

