/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import com.google.inject.Key;
import com.google.inject.name.Names;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.configuration.enums.BackupFrequency;
import org.tlauncher.tlauncher.configuration.enums.BackupSetting;
import org.tlauncher.tlauncher.configuration.enums.BackupToolTips;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.console.Console;
import org.tlauncher.tlauncher.ui.converter.ActionOnLaunchConverter;
import org.tlauncher.tlauncher.ui.converter.BackupFrequencyConverter;
import org.tlauncher.tlauncher.ui.converter.ConnectionQualityConverter;
import org.tlauncher.tlauncher.ui.converter.ConsoleTypeConverter;
import org.tlauncher.tlauncher.ui.converter.LocaleConverter;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.editor.EditorComboBox;
import org.tlauncher.tlauncher.ui.editor.EditorFieldChangeListener;
import org.tlauncher.tlauncher.ui.editor.EditorTextField;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.scenes.SettingsScene;
import org.tlauncher.tlauncher.ui.settings.HandlerSettings;
import org.tlauncher.tlauncher.ui.settings.PageSettings;
import org.tlauncher.tlauncher.ui.settings.SettingElement;
import org.tlauncher.tlauncher.ui.swing.scroll.VersionScrollBarUI;
import org.tlauncher.tlauncher.ui.ui.TlauncherBasicComboBoxUI;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;

public class TlauncherSettings
extends PageSettings {
    private static final long serialVersionUID = -555851839208513067L;
    public final TLauncher tlauncher = TLauncher.getInstance();
    public final Configuration global = this.tlauncher.getConfiguration();
    public final LangConfiguration lang = this.tlauncher.getLang();
    private final EditorComboBox<Locale> local;

    public TlauncherSettings() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        EditorComboBox<ConsoleType> consoleConverter = new EditorComboBox<ConsoleType>(new ConsoleTypeConverter(), ConsoleType.values());
        EditorCheckBox statistics = new EditorCheckBox("statistics.settings.checkbox.name");
        EditorCheckBox guard = new EditorCheckBox("settings.guard");
        EditorCheckBox recommendedServers = new EditorCheckBox("settings.servers.recommendation");
        EditorCheckBox doBackup = new EditorCheckBox("ui.yes");
        doBackup.setPreferredSize(new Dimension(70, doBackup.getHeight()));
        doBackup.setSelected(!this.global.getBoolean(BackupSetting.SKIP_USER_BACKUP.toString()));
        JLabel questionLabel = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        JLabel doBackupQuestionLabel = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        JLabel backupTitleQuestionLabel = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        EditorComboBox<ConnectionQuality> connQuality = new EditorComboBox<ConnectionQuality>(new ConnectionQualityConverter(), ConnectionQuality.values());
        EditorComboBox<ActionOnLaunch> launchAction = new EditorComboBox<ActionOnLaunch>(new ActionOnLaunchConverter(), ActionOnLaunch.values());
        EditorComboBox<BackupFrequency> backupFrequency = new EditorComboBox<BackupFrequency>(new BackupFrequencyConverter(), BackupFrequency.values());
        this.local = new EditorComboBox<Locale>(new LocaleConverter(), this.global.getLocales());
        TlauncherSettings.setTLauncherBasicComboBoxUI(consoleConverter);
        TlauncherSettings.setTLauncherBasicComboBoxUI(connQuality);
        TlauncherSettings.setTLauncherBasicComboBoxUI(launchAction);
        TlauncherSettings.setTLauncherBasicComboBoxUI(this.local);
        TlauncherSettings.setTLauncherBasicComboBoxUI(backupFrequency);
        SettingElement settingElement = new SettingElement("settings.console.label", consoleConverter, 21);
        springLayout.putConstraint("North", (Component)settingElement, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)settingElement, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement, 21, "North", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement, 0, "East", (Component)this);
        this.add((Component)settingElement);
        SettingElement settingElement_2 = new SettingElement("statistics.settings.title", statistics, 17, -1);
        springLayout.putConstraint("North", (Component)settingElement_2, 15, "South", (Component)settingElement);
        springLayout.putConstraint("West", (Component)settingElement_2, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_2, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_2, 38, "South", (Component)settingElement);
        this.add((Component)settingElement_2);
        SettingElement settingElement_guard = new SettingElement("settings.guard.title", (JComponent)guard, 19, -1, questionLabel);
        questionLabel.setBounds(0, 0, 20, 19);
        springLayout.putConstraint("North", (Component)settingElement_guard, 15, "South", (Component)settingElement_2);
        springLayout.putConstraint("West", (Component)settingElement_guard, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_guard, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_guard, 38, "South", (Component)settingElement_2);
        this.add((Component)settingElement_guard);
        SettingElement settingElement_servers = new SettingElement("settings.servers.recommendation.title", recommendedServers, 19, -1);
        springLayout.putConstraint("North", (Component)settingElement_servers, 15, "South", (Component)settingElement_guard);
        springLayout.putConstraint("West", (Component)settingElement_servers, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_servers, 0, "East", (Component)this);
        this.add((Component)settingElement_servers);
        SettingElement settingElement_3 = new SettingElement("settings.connection.label", connQuality, 21);
        springLayout.putConstraint("North", (Component)settingElement_3, 15, "South", (Component)settingElement_servers);
        springLayout.putConstraint("West", (Component)settingElement_3, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_3, 0, "East", (Component)this);
        this.add((Component)settingElement_3);
        SettingElement settingElement_4 = new SettingElement("settings.launch-action.label", launchAction, 21);
        springLayout.putConstraint("North", (Component)settingElement_4, 15, "South", (Component)settingElement_3);
        springLayout.putConstraint("West", (Component)settingElement_4, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_4, 0, "East", (Component)this);
        this.add((Component)settingElement_4);
        SettingElement settingElement_5 = new SettingElement("settings.lang.label", this.local, 21);
        springLayout.putConstraint("North", (Component)settingElement_5, 15, "South", (Component)settingElement_4);
        springLayout.putConstraint("West", (Component)settingElement_5, 0, "West", (Component)settingElement);
        springLayout.putConstraint("East", (Component)settingElement_5, 0, "East", (Component)settingElement);
        this.add((Component)settingElement_5);
        EditorTextField maxBackupSizeEditorField = new EditorTextField();
        EditorTextField maxTimeForBackupEditorField = new EditorTextField();
        EditorTextField backupRepetitionEditorField = new EditorTextField();
        maxTimeForBackupEditorField.setColumns(5);
        maxBackupSizeEditorField.setColumns(5);
        backupRepetitionEditorField.setText(this.tlauncher.getConfiguration().get(BackupSetting.REPEAT_BACKUP.toString()));
        JPanel backupTitlePanel = new JPanel();
        LocalizableLabel backupTitle = new LocalizableLabel("settings.backup.title");
        backupTitlePanel.setPreferredSize(new Dimension(backupTitlePanel.getWidth(), 27));
        backupTitle.setFont(SettingElement.LABEL_FONT);
        backupTitlePanel.add(backupTitle);
        backupTitlePanel.add(backupTitleQuestionLabel);
        backupTitlePanel.setBackground(SettingsScene.BACKGROUND);
        backupTitleQuestionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String stringPath = MinecraftUtil.buildWorkingPath("versions") + File.separator + Localizable.get("version.name") + File.separator + "saves";
                Alert.showHtmlMessage(Localizable.get("settings.backup.title"), Localizable.get(BackupToolTips.TITLE.toString(), MinecraftUtil.buildWorkingPath("backup/saves"), TlauncherSettings.this.tlauncher.getConfiguration().get(BackupSetting.FREE_PARTITION_SIZE.toString()), MinecraftUtil.buildWorkingPath("saves"), stringPath, MinecraftUtil.buildWorkingPath("backup/saves")), 1, 700);
            }
        });
        doBackupQuestionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Alert.showCustomMonolog(Localizable.get("settings.doBackup").replace(":", ""), Localizable.get("settings.doBackup.tooltip"));
            }
        });
        springLayout.putConstraint("North", (Component)backupTitlePanel, 5, "South", (Component)settingElement_5);
        springLayout.putConstraint("West", (Component)backupTitlePanel, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)backupTitlePanel, 0, "East", (Component)this);
        this.add((Component)backupTitlePanel);
        JPanel doBackupPanel = new JPanel();
        EditorTextField doBackupEditorField = new EditorTextField();
        doBackupPanel.setBackground(SettingsScene.BACKGROUND);
        doBackupEditorField.setVisible(false);
        doBackupPanel.add(doBackup);
        doBackupPanel.add(doBackupEditorField);
        doBackup.addActionListener(e -> this.initBackupCheckbox(doBackup, backupFrequency, maxBackupSizeEditorField, maxTimeForBackupEditorField, backupRepetitionEditorField, doBackupEditorField));
        this.initBackupCheckbox(doBackup, backupFrequency, maxBackupSizeEditorField, maxTimeForBackupEditorField, backupRepetitionEditorField, doBackupEditorField);
        backupFrequency.addActionListener(e -> {
            if (backupFrequency.getSelectedValue() != null) {
                String s = ((BackupFrequency)((Object)((Object)backupFrequency.getSelectedValue()))).toString();
                if (s.equals(BackupFrequency.EVERYTIME.toString())) {
                    backupRepetitionEditorField.setText("0");
                } else if (s.equals(BackupFrequency.OFTEN.toString())) {
                    backupRepetitionEditorField.setText("1");
                }
            }
        });
        SettingElement settingElement_6 = new SettingElement("settings.doBackup", (JComponent)doBackup, 20, -1, doBackupQuestionLabel);
        springLayout.putConstraint("North", (Component)settingElement_6, 0, "South", (Component)backupTitlePanel);
        springLayout.putConstraint("West", (Component)settingElement_6, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_6, 0, "East", (Component)this);
        this.add((Component)settingElement_6);
        SettingElement settingElement_7 = new SettingElement("settings.backup.frequency", backupFrequency, 27);
        springLayout.putConstraint("North", (Component)settingElement_7, 5, "South", (Component)settingElement_6);
        springLayout.putConstraint("West", (Component)settingElement_7, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_7, 0, "East", (Component)this);
        this.add((Component)settingElement_7);
        JPanel maxBackupSizePanel = this.getCommonPanel("progress.bar.panel.size", "settings.max.backup.size", BackupToolTips.MAX_BACKUP_SIZE.toString());
        SettingElement settingElement_8 = new SettingElement("settings.max.backup.size", (JComponent)maxBackupSizeEditorField, 27, -1, maxBackupSizePanel);
        springLayout.putConstraint("North", (Component)settingElement_8, 4, "South", (Component)settingElement_7);
        springLayout.putConstraint("West", (Component)settingElement_8, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_8, 0, "East", (Component)this);
        this.add((Component)settingElement_8);
        JPanel maxTimeForBackupPanel = this.getCommonPanel("progress.bar.panel.remaining.time.days", "settings.max.backup.time", BackupToolTips.MAX_BACKUP_SAVE_TIME.toString());
        SettingElement settingElement_9 = new SettingElement("settings.max.backup.time", (JComponent)maxTimeForBackupEditorField, 27, -1, maxTimeForBackupPanel);
        springLayout.putConstraint("North", (Component)settingElement_9, 0, "South", (Component)settingElement_8);
        springLayout.putConstraint("West", (Component)settingElement_9, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_9, 0, "East", (Component)this);
        this.add((Component)settingElement_9);
        EditorFieldChangeListener changeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldvalue, String newvalue) {
                Console c = (Console)TLauncher.getInjector().getInstance(Key.get(Console.class, (Annotation)Names.named((String)"console")));
                switch (ConsoleType.get(newvalue)) {
                    case GLOBAL: {
                        c.show(false);
                        break;
                    }
                    case NONE: {
                        c.hide();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown console type!");
                    }
                }
            }
        };
        EditorFieldChangeListener conQualityListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldValue, String newValue) {
                TlauncherSettings.this.tlauncher.getDownloader().setConfiguration(TlauncherSettings.this.global.getConnectionQuality());
            }
        };
        EditorFieldChangeListener localeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldvalue, String newvalue) {
                if (TlauncherSettings.this.tlauncher.getFrame() != null) {
                    TlauncherSettings.this.tlauncher.getFrame().updateLocales();
                }
            }
        };
        this.addHandler(new HandlerSettings("gui.console", consoleConverter, changeListener));
        this.addHandler(new HandlerSettings("gui.statistics.checkbox", statistics));
        this.addHandler(new HandlerSettings("gui.settings.guard.checkbox", guard));
        this.addHandler(new HandlerSettings("gui.settings.servers.recommendation", recommendedServers));
        this.addHandler(new HandlerSettings("connection", connQuality, conQualityListener));
        this.addHandler(new HandlerSettings("minecraft.onlaunch", launchAction));
        this.addHandler(new HandlerSettings("locale", this.local, localeListener));
        this.addHandler(new HandlerSettings(BackupSetting.MAX_SIZE_FOR_WORLD.toString(), maxBackupSizeEditorField));
        this.addHandler(new HandlerSettings(BackupSetting.MAX_TIME_FOR_BACKUP.toString(), maxTimeForBackupEditorField));
        this.addHandler(new HandlerSettings(BackupSetting.REPEAT_BACKUP.toString(), backupFrequency));
        this.addHandler(new HandlerSettings(BackupSetting.SKIP_USER_BACKUP.toString(), doBackupEditorField));
        questionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://tlauncher.org/%s/guard.html", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "ru" : "en");
                    OS.openLink(url);
                }
            }
        });
        ActionListener l = e -> {
            if (this.tlauncher.getProfileManager().isNotPremium()) {
                ((JCheckBox)e.getSource()).setSelected(true);
                Alert.showHtmlMessage("", Localizable.get("account.premium.not.available"), 1, 400);
            }
        };
        recommendedServers.addActionListener(l);
        guard.addActionListener(l);
    }

    private JPanel getCommonPanel(String text, final String title, final String toolTipText) {
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(SettingsScene.BACKGROUND);
        mainPanel.add(new LocalizableLabel(text));
        JLabel questionMark = new JLabel(new ImageIcon(ImageCache.getImage((String)"qestion-option-panel.png")));
        questionMark.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Alert.showCustomMonolog(Localizable.get(title).replace(":", ""), Localizable.get(toolTipText));
            }
        });
        mainPanel.add(questionMark);
        return mainPanel;
    }

    private static <T> void setTLauncherBasicComboBoxUI(JComboBox<T> comboBox) {
        comboBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(149, 149, 149)));
        comboBox.setUI(new TlauncherBasicComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                BasicComboPopup basic = new BasicComboPopup(this.comboBox){

                    @Override
                    protected JScrollPane createScroller() {
                        VersionScrollBarUI barUI = new VersionScrollBarUI(){

                            @Override
                            protected Dimension getMinimumThumbSize() {
                                return new Dimension(10, 40);
                            }

                            @Override
                            public Dimension getMaximumSize(JComponent c) {
                                Dimension dim = super.getMaximumSize(c);
                                dim.setSize(10.0, dim.getHeight());
                                return dim;
                            }

                            @Override
                            public Dimension getPreferredSize(JComponent c) {
                                Dimension dim = super.getPreferredSize(c);
                                dim.setSize(13.0, dim.getHeight());
                                return dim;
                            }
                        };
                        barUI.setGapThubm(5);
                        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                        scroller.getVerticalScrollBar().setUI(barUI);
                        return scroller;
                    }
                };
                basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.GRAY));
                return basic;
            }
        });
    }

    public boolean chooseChinaLocal() {
        if (Objects.isNull(this.global.getLocale())) {
            return false;
        }
        return ((Locale)this.local.getSelectedValue()).getLanguage().equals(new Locale("zh").getLanguage()) || this.global.getLocale().getLanguage().equals(new Locale("zh").getLanguage());
    }

    private void initBackupCheckbox(EditorCheckBox doBackup, EditorComboBox<BackupFrequency> backupFrequency, EditorTextField maxBackupSizeEditorField, EditorTextField maxTimeForBackupEditorField, EditorTextField backupRepetitionEditorField, EditorTextField doBackupEditorField) {
        if (doBackup.isSelected()) {
            maxTimeForBackupEditorField.setEditable(true);
            maxBackupSizeEditorField.setEditable(true);
            backupRepetitionEditorField.setEditable(true);
            backupFrequency.setEnabled(true);
            doBackupEditorField.setText("false");
        } else {
            maxTimeForBackupEditorField.setEditable(false);
            maxBackupSizeEditorField.setEditable(false);
            backupRepetitionEditorField.setEditable(false);
            backupFrequency.setEnabled(false);
            doBackupEditorField.setText("true");
        }
    }
}

