/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.center.CenterPanelTheme;
import org.tlauncher.tlauncher.ui.editor.EditorHandler;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.images.ImageIcon;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;

public abstract class AbstractEditorPanel
extends CenterPanel {
    protected final List<EditorHandler> handlers = new ArrayList<EditorHandler>();

    public AbstractEditorPanel(CenterPanelTheme theme, Insets insets) {
        super(theme, insets);
    }

    public AbstractEditorPanel(Insets insets) {
        this(null, insets);
    }

    public AbstractEditorPanel() {
        this(null, null);
    }

    protected boolean checkValues() {
        boolean allValid = true;
        for (EditorHandler handler : this.handlers) {
            boolean valid = handler.isValid();
            this.setValid(handler, valid);
            if (valid) continue;
            allValid = false;
        }
        return allValid;
    }

    protected void setValid(EditorHandler handler, boolean valid) {
        Color color = valid ? this.getTheme().getBackground() : this.getTheme().getFailure();
        handler.getComponent().setOpaque(!valid);
        handler.getComponent().setBackground(color);
    }

    protected JComponent createTip(String label, boolean warning) {
        LocalizableLabel tip = new LocalizableLabel(label);
        if (warning) {
            ImageIcon.setup((JLabel)tip, (ImageIcon)ImageCache.getIcon((String)"warning.png", (int)16, (int)16));
        }
        return tip;
    }
}

