/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.entity.profile.ClientProfile;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.managers.ProfileManagerListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.accounts.AccountEditor;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.AccountCellRenderer;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedButton;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.scroll.AccountScrollBarUI;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class AccountList
extends CenterPanel
implements ProfileManagerListener {
    public static final Dimension SIZE = new Dimension(211, 171);
    private static final long serialVersionUID = 3280495266368287215L;
    public final DefaultListModel<Account> model;
    public final JList<Account> list;
    public final UpdaterButton add;
    public final UpdaterButton remove;
    private final AccountEditorScene scene;
    private final ProfileManager profileManager;
    private final Account temp = new Account();

    public AccountList(AccountEditorScene sc) {
        super(noInsets);
        this.setPreferredSize(SIZE);
        this.scene = sc;
        this.profileManager = TLauncher.getInstance().getProfileManager();
        ExtendedPanel panel = new ExtendedPanel(new BorderLayout(0, 0));
        LocalizableLabel label = new LocalizableLabel("account.list");
        SwingUtil.changeFontFamily(label, FontTL.ROBOTO_BOLD);
        label.setFont(label.getFont().deriveFont(14.0f));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 13, 0));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        this.model = new DefaultListModel();
        this.list = new JList<Account>(this.model);
        this.list.setCellRenderer(new AccountCellRenderer(AccountCellRenderer.AccountCellType.EDITOR));
        this.list.setSelectionMode(0);
        this.list.setBackground(AccountEditorScene.BACKGROUND_ACCOUNT_COLOR);
        this.list.addListSelectionListener(e -> {
            if (Objects.nonNull(this.list.getSelectedValue())) {
                this.scene.editor.fillFormBySelectedAccount(this.list.getSelectedValue());
            } else {
                this.scene.editor.clear();
            }
            this.blockOrUnblock();
        });
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.getVerticalScrollBar().setUI(new AccountScrollBarUI());
        scroll.setBorder(null);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(20);
        ExtendedPanel buttons = new ExtendedPanel();
        buttons.setLayout(new FlowLayout(0, 0, 0));
        buttons.setPreferredSize(new Dimension(AccountList.SIZE.width, 26));
        this.add = new UpdaterButton(ExtendedButton.ORANGE_COLOR, "account.list.add");
        this.add.setFont(this.add.getFont().deriveFont(1, 16.0f));
        this.add.setForeground(Color.WHITE);
        this.add.setPreferredSize(new Dimension(100, 26));
        this.add.addActionListener(e -> {
            for (int i = 0; i < this.model.getSize(); ++i) {
                if (this.model.getElementAt(i).getUsername() != null) continue;
                return;
            }
            this.model.addElement(this.temp);
            this.list.setSelectedValue(this.temp, true);
            this.defocus();
        });
        this.remove = new UpdaterButton(ImageUdaterButton.ORANGE_COLOR, "account.list.remove");
        this.remove.setPreferredSize(new Dimension(100, 26));
        this.remove.setFont(this.remove.getFont().deriveFont(1, 16.0f));
        this.remove.setForeground(Color.WHITE);
        this.remove.addActionListener(e -> {
            Account ac = this.list.getSelectedValue();
            if (Objects.nonNull(ac)) {
                this.model.removeElement(ac);
                try {
                    this.profileManager.remove(ac);
                }
                catch (IOException exception) {
                    U.log(exception);
                }
                this.defocus();
            }
        });
        ((Container)buttons).add(this.add);
        ((Container)buttons).add(Box.createHorizontalStrut(11));
        ((Container)buttons).add(this.remove);
        panel.add("South", (Component)buttons);
        panel.add("Center", (Component)scroll);
        panel.add("North", (Component)label);
        this.add((Component)panel);
    }

    public void addTempToList() {
        this.model.addElement(this.temp);
        this.list.setSelectedValue(this.temp, true);
    }

    @Override
    public void fireRefreshed(ClientProfile cl) {
        SwingUtilities.invokeLater(() -> {
            boolean hasTemp = this.model.contains(this.temp);
            this.fireClientProfileChanged(cl);
            if (hasTemp) {
                this.addTempToList();
                this.blockOrUnblock();
            }
        });
    }

    @Override
    public void fireClientProfileChanged(ClientProfile cl) {
        SwingUtilities.invokeLater(() -> {
            this.model.clear();
            for (Account account : cl.getAccounts().values()) {
                if (account.getShortUUID().equalsIgnoreCase(cl.getSelectedAccountUUID())) {
                    this.list.setSelectedValue(account, true);
                    Blocker.unblock("auth", this.scene.editor);
                }
                this.model.addElement(account);
            }
            this.blockOrUnblock();
        });
    }

    private void blockOrUnblock() {
        if (Objects.isNull(this.list.getSelectedValue())) {
            Blocker.block("auth", this.scene.editor);
        } else if (this.list.getSelectedValue().equals(this.temp)) {
            Blocker.unblock("auth", this.scene.editor);
        } else {
            Blocker.unblock("auth", this.scene.editor);
            for (AccountEditor.AuthTypeRadio o : this.scene.editor.radioMap.values()) {
                o.setEnabled(false);
            }
            if (Account.AccountType.OFFICIAL_ACCOUNTS.contains((Object)this.list.getSelectedValue().getType())) {
                Blocker.block("auth", this.scene.editor);
            }
        }
    }

    public void setTempAccountType(Account.AccountType accountType) {
        this.temp.setType(accountType);
        this.list.revalidate();
        this.list.repaint();
    }

    public Account getAccountFromSelected() {
        if (this.temp.equals(this.list.getSelectedValue())) {
            Account ac = new Account();
            ac.setType(this.temp.getType());
            return ac;
        }
        return this.list.getSelectedValue();
    }
}

