/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.listeners.auth;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.tlauncher.tlauncher.exceptions.auth.NotCorrectTokenOrIdException;
import org.tlauncher.tlauncher.listeners.auth.AuthenticatorSaveListener;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.listeners.auth.RefreshTokenListener;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.util.U;

public class ValidateAccountToken
implements LoginProcessListener {
    private final RefreshTokenListener refreshTokenListener = new RefreshTokenListener(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validatePreGameLaunch() throws LoginException {
        ProfileManager profile = TLauncher.getInstance().getProfileManager();
        Account ac = profile.getSelectedAccount();
        Authenticator authenticator = Authenticator.instanceFor(ac);
        authenticator.addListener(new AuthenticatorSaveListener());
        authenticator.addListener(this.refreshTokenListener);
        try {
            RefreshTokenListener refreshTokenListener = this.refreshTokenListener;
            synchronized (refreshTokenListener) {
                CompletableFuture.runAsync(authenticator);
                this.refreshTokenListener.wait();
            }
        }
        catch (InterruptedException e) {
            U.log(e);
        }
        if (this.refreshTokenListener.getException() instanceof NotCorrectTokenOrIdException) {
            try {
                profile.remove(ac);
            }
            catch (IOException e) {
                U.log(e);
            }
            throw new LoginException(this.refreshTokenListener.getException().getMessage());
        }
    }
}

