/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.configuration;

import java.util.HashMap;
import java.util.Map;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.tlauncher.tlauncher.ui.alert.Alert;

public class ArgumentParser {
    private static final Map<String, String> m = ArgumentParser.createLinkMap();
    private static final OptionParser parser = ArgumentParser.createParser();

    public static OptionParser getParser() {
        return parser;
    }

    public static OptionSet parseArgs(String[] args) {
        OptionSet set = null;
        try {
            set = parser.parse(args);
        }
        catch (OptionException e) {
            e.printStackTrace();
            Alert.showError((Object)e, false);
        }
        return set;
    }

    public static Map<String, Object> parse(OptionSet set) {
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (set == null) {
            return r;
        }
        for (Map.Entry<String, String> a : m.entrySet()) {
            String key = a.getKey();
            Object value = null;
            if (key.startsWith("-")) {
                key = key.substring(1);
                value = true;
            }
            if (!set.has(key)) continue;
            if (value == null) {
                value = set.valueOf(key);
            }
            r.put(a.getValue(), value);
        }
        return r;
    }

    private static Map<String, String> createLinkMap() {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("directory", "minecraft.gamedir");
        r.put("java-directory", "minecraft.javadir");
        r.put("version", "login.version.game");
        r.put("usertype", "login.account.type");
        r.put("javaargs", "minecraft.javaargs");
        r.put("margs", "minecraft.args");
        r.put("window", "minecraft.size");
        r.put("background", "gui.background");
        r.put("fullscreen", "minecraft.fullscreen");
        r.put("RunAllTLauncherVersions", "run.all.tlauncher.versions");
        r.put("RunAllOfficialVersions", "run.all.official.versions");
        return r;
    }

    private static OptionParser createParser() {
        OptionParser parser = new OptionParser();
        parser.accepts("help", "Shows this help");
        parser.accepts("nogui", "Starts minimal version");
        parser.accepts("directory", "Specifies Minecraft directory").withRequiredArg();
        parser.accepts("java-directory", "Specifies Java directory").withRequiredArg();
        parser.accepts("version", "Specifies version to run").withRequiredArg();
        parser.accepts("javaargs", "Specifies JVM arguments").withRequiredArg();
        parser.accepts("margs", "Specifies Minecraft arguments").withRequiredArg();
        parser.accepts("window", "Specifies window size in format: width;height").withRequiredArg();
        parser.accepts("settings", "Specifies path to settings file").withRequiredArg();
        parser.accepts("background", "Specifies background image. URL links, JPEG and PNG formats are supported.").withRequiredArg();
        parser.accepts("fullscreen", "Specifies whether fullscreen mode enabled or not").withRequiredArg();
        parser.accepts("RunAllTLauncherVersions", "Run all tlauncher versions").withRequiredArg();
        parser.accepts("RunAllOfficialVersions", "Run all official versions").withRequiredArg();
        return parser;
    }
}

