/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tukaani.xz.XZInputStream;

public class Library {
    private static final String FORGE_LIB_SUFFIX = ".pack.xz";
    private static final StrSubstitutor SUBSTITUTOR;
    private String name;
    private List<Rule> rules;
    private Map<OS, String> natives;
    private ExtractRules extract;
    private List<String> deleteEntries;
    private MetadataDTO artifact;
    private Map<String, MetadataDTO> classifies;
    private String url;
    private String exact_url;
    private String packed;
    private String checksum;

    private String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] parts = this.name.split(":");
        return String.format("%s/%s/%s", parts[0].replaceAll("\\.", "/"), parts[1], parts[2]);
    }

    public String getName() {
        return this.name;
    }

    public String getPlainName() {
        String[] split = this.name.split(":");
        return split[0] + "." + split[1];
    }

    public List<Rule> getRules() {
        return this.rules == null ? null : Collections.unmodifiableList(this.rules);
    }

    boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule rule : this.rules) {
            Rule.Action action = rule.getAppliedAction();
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public Map<OS, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public String getChecksum() {
        MetadataDTO meta = this.defineMetadataLibrary(OS.CURRENT);
        if (meta != null) {
            return meta.getSha1();
        }
        if (this.artifact != null) {
            return this.artifact.getSha1();
        }
        return this.checksum;
    }

    public List<String> getDeleteEntriesList() {
        return this.deleteEntries;
    }

    public String getArtifactPath(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(classifier));
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    private String getArtifactFilename(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] parts = this.name.split(":");
        String result = classifier == null ? IntStream.range(1, parts.length).mapToObj(i -> parts[i]).collect(Collectors.joining("-")) + ".jar" : String.format("%s-%s%s.jar", parts[1], parts[2], "-" + classifier);
        return SUBSTITUTOR.replace(result);
    }

    public String toString() {
        return "Library{name='" + this.name + '\'' + ", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + ", packed='" + this.packed + "'}";
    }

    public Downloadable getDownloadable(Repo versionSource, File file, OS os) {
        String path;
        Repo repo = null;
        boolean isForge = "forge".equals(this.packed);
        Downloadable lib = this.determineNewSource(file, os);
        if (lib != null) {
            return lib;
        }
        if (this.exact_url == null) {
            String nativePath = this.natives != null && this.appliesToCurrentEnvironment() ? this.natives.get((Object)os) : null;
            path = this.getArtifactPath(nativePath) + (isForge ? FORGE_LIB_SUFFIX : "");
            if (this.url == null) {
                repo = ClientInstanceRepo.LIBRARY_REPO;
            } else if (this.url.startsWith("/")) {
                repo = versionSource;
                path = this.url.substring(1) + path;
            } else {
                path = this.url + path;
            }
        } else {
            path = this.exact_url;
        }
        if (isForge) {
            File tempFile = new File(file.getAbsolutePath() + FORGE_LIB_SUFFIX);
            MetadataDTO metadataDTO = new MetadataDTO();
            metadataDTO.setUrl(path);
            metadataDTO.setLocalDestination(tempFile);
            return new ForgeLibDownloadable(ClientInstanceRepo.EMPTY_REPO, metadataDTO, file);
        }
        MetadataDTO metadataDTO = new MetadataDTO();
        metadataDTO.setUrl(path);
        metadataDTO.setLocalDestination(file);
        return repo == null ? new Downloadable(ClientInstanceRepo.EMPTY_REPO, metadataDTO) : new Downloadable(repo, metadataDTO);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private Downloadable determineNewSource(File file, OS os) {
        MetadataDTO meta = this.defineMetadataLibrary(os);
        if (meta != null) {
            meta.setLocalDestination(file);
            return new Downloadable(ClientInstanceRepo.EMPTY_REPO, meta);
        }
        if (this.artifact != null) {
            this.artifact.setLocalDestination(file);
            return new Downloadable(ClientInstanceRepo.EMPTY_REPO, this.artifact);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void unpackLibrary(File library, File output, boolean retryOnOutOfMemory) throws IOException {
        Library.forgeLibLog("Synchronized unpacking:", library);
        output.delete();
        FileInputStream in = null;
        JarOutputStream jos = null;
        try {
            in = new FileInputStream(library);
            in = new XZInputStream((InputStream)in);
            Library.forgeLibLog("Decompressing...");
            byte[] decompressed = Library.readFully(in);
            Library.forgeLibLog("Decompressed successfully");
            String end = new String(decompressed, decompressed.length - 4, 4);
            if (!end.equals("SIGN")) {
                throw new RetryDownloadException("signature missing");
            }
            Library.forgeLibLog("Signature matches!");
            int x = decompressed.length;
            int len = decompressed[x - 8] & 0xFF | (decompressed[x - 7] & 0xFF) << 8 | (decompressed[x - 6] & 0xFF) << 16 | (decompressed[x - 5] & 0xFF) << 24;
            Library.forgeLibLog("Now getting checksums...");
            byte[] checksums = Arrays.copyOfRange(decompressed, decompressed.length - len - 8, decompressed.length - 8);
            FileUtil.createFile(output);
            FileOutputStream jarBytes = new FileOutputStream(output);
            jos = new JarOutputStream(jarBytes);
            Library.forgeLibLog("Now unpacking...");
            Pack200.newUnpacker().unpack((InputStream)new ByteArrayInputStream(decompressed), jos);
            Library.forgeLibLog("Unpacked successfully");
            Library.forgeLibLog("Now trying to write checksums...");
            jos.putNextEntry(new JarEntry("checksums.sha1"));
            jos.write(checksums);
            jos.closeEntry();
            Library.forgeLibLog("Now finishing...");
        }
        catch (OutOfMemoryError oomE) {
            block7: {
                try {
                    Library.forgeLibLog("Out of memory, oops", oomE);
                    U.gc();
                    if (!retryOnOutOfMemory) break block7;
                    Library.forgeLibLog("Retrying...");
                    Library.close(in, jos);
                    FileUtil.deleteFile(library);
                    Library.unpackLibrary(library, output, false);
                }
                catch (Throwable throwable) {
                    Library.close(in, jos);
                    FileUtil.deleteFile(library);
                    throw throwable;
                }
                Library.close(in, jos);
                FileUtil.deleteFile(library);
                return;
            }
            throw oomE;
            catch (IOException e) {
                output.delete();
                throw e;
            }
        }
        Library.close(in, jos);
        FileUtil.deleteFile(library);
        Library.forgeLibLog("Done:", output);
        return;
    }

    private static synchronized void unpackLibrary(File library, File output) throws IOException {
        Library.unpackLibrary(library, output, true);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    private static void forgeLibLog(Object ... o) {
        U.log("[ForgeLibDownloadable]", o);
    }

    private MetadataDTO defineMetadataLibrary(OS os) {
        if (this.classifies != null && this.natives != null) {
            if (this.classifies.get(os.name().toLowerCase()) != null) {
                return this.classifies.get(os.name().toLowerCase());
            }
            if (this.classifies.get(os.name().toLowerCase() + "-" + OS.Arch.CURRENT.name().replace("x", "")) != null) {
                return this.classifies.get(os.name().toLowerCase() + "-" + OS.Arch.CURRENT.name().replace("x", ""));
            }
        }
        return null;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("platform", OS.CURRENT.getName());
        map.put("arch", OS.Arch.CURRENT.asString());
        SUBSTITUTOR = new StrSubstitutor(map);
    }

    public static class ForgeLibDownloadable
    extends Downloadable {
        private final File unpacked;

        private ForgeLibDownloadable(Repo rep, MetadataDTO metadataDTO, File unpackedLib) {
            super(rep, metadataDTO);
            this.unpacked = unpackedLib;
        }

        @Override
        protected void onComplete() throws RetryDownloadException {
            super.onComplete();
            try {
                Library.unpackLibrary(this.getMetadataDTO().getLocalDestination(), this.unpacked);
            }
            catch (Throwable t) {
                throw new RetryDownloadException("cannot unpack forge library", t);
            }
        }
    }

    public static class LibrarySerializer
    implements JsonSerializer<Library>,
    JsonDeserializer<Library> {
        private final Gson gson;

        public LibrarySerializer() {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
            builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
            builder.enableComplexMapKeySerialization();
            this.gson = builder.create();
        }

        @Override
        public Library deserialize(JsonElement elem, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = elem.getAsJsonObject();
            JsonObject downloads = object.getAsJsonObject("downloads");
            if (downloads != null) {
                JsonObject classifies;
                JsonElement artifact = downloads.get("artifact");
                if (artifact != null) {
                    object.add("artifact", artifact);
                }
                if ((classifies = downloads.getAsJsonObject("classifiers")) != null) {
                    Set<Map.Entry<String, JsonElement>> set = classifies.entrySet();
                    JsonObject ob = new JsonObject();
                    block28: for (Map.Entry<String, JsonElement> el : set) {
                        switch (el.getKey()) {
                            case "natives-linux": {
                                ob.add(OS.LINUX.name().toLowerCase(), el.getValue());
                                continue block28;
                            }
                            case "natives-windows": {
                                ob.add(OS.WINDOWS.name().toLowerCase(), el.getValue());
                                continue block28;
                            }
                            case "natives-macos": {
                                ob.add(OS.OSX.name().toLowerCase(), el.getValue());
                                continue block28;
                            }
                            case "natives-windows-32": {
                                ob.add(OS.WINDOWS.name().toLowerCase() + "-32", el.getValue());
                                continue block28;
                            }
                            case "natives-windows-64": {
                                ob.add(OS.WINDOWS.name().toLowerCase() + "-64", el.getValue());
                                continue block28;
                            }
                            case "natives-osx": {
                                ob.add(OS.OSX.name().toLowerCase(), el.getValue());
                                continue block28;
                            }
                            case "tests": {
                                ob.add("tests", el.getValue());
                                continue block28;
                            }
                            case "sources": {
                                ob.add("sources", el.getValue());
                                continue block28;
                            }
                            case "javadoc": {
                                ob.add("javadoc", el.getValue());
                                continue block28;
                            }
                            case "linux-aarch_64": {
                                ob.add("linux-aarch_64", el.getValue());
                                continue block28;
                            }
                            case "linux-x86_64": {
                                ob.add("linux-x86_64", el.getValue());
                                continue block28;
                            }
                            case "natives-macos-arm64": {
                                ob.add("natives-macos-arm64", el.getValue());
                                continue block28;
                            }
                        }
                        U.log("can't find proper config for ", el);
                    }
                    object.add("classifies", ob);
                }
                object.remove("downloads");
            }
            return this.gson.fromJson(elem, Library.class);
        }

        @Override
        public JsonElement serialize(Library library, Type type, JsonSerializationContext context) {
            return this.gson.toJsonTree(library, type);
        }
    }

    public static enum TYPE {
        CLASSIFIES,
        ARTIFACT;

    }
}

