/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.model.Headers;
import by.gdev.http.download.model.RequestMetadata;
import by.gdev.http.download.service.HttpService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpServiceImpl
implements HttpService {
    private String proxy;
    private CloseableHttpClient httpclient;
    private RequestConfig requestConfig;
    private int maxAttepmts;

    @Override
    public RequestMetadata getRequestByUrlAndSave(String url, Path path) throws IOException {
        RequestMetadata request = null;
        for (int attepmts = 0; attepmts < this.maxAttepmts; ++attepmts) {
            try {
                request = this.getResourseByUrl(url, path);
                break;
            }
            catch (SocketTimeoutException e1) {
                if (++attepmts != this.maxAttepmts) continue;
                throw new SocketTimeoutException();
            }
            catch (IOException e) {
                if (Objects.nonNull(this.proxy)) {
                    request = this.getResourseByUrl(this.proxy + url, path);
                    continue;
                }
                throw e;
            }
        }
        return request;
    }

    @Override
    public RequestMetadata getMetaByUrl(String url) throws IOException {
        RequestMetadata request = null;
        for (int attepmts = 0; attepmts < this.maxAttepmts; ++attepmts) {
            try {
                request = this.getMetadata(url);
                break;
            }
            catch (SocketTimeoutException e) {
                if (++attepmts != this.maxAttepmts) continue;
                throw new SocketTimeoutException();
            }
        }
        return request;
    }

    @Override
    public String getRequestByUrl(String url) throws IOException {
        SocketTimeoutException ste = null;
        for (int attepmts = 0; attepmts < this.maxAttepmts; ++attepmts) {
            try {
                return this.getStringByUrl(url);
            }
            catch (SocketTimeoutException e) {
                ste = e;
                continue;
            }
        }
        throw ste;
    }

    private String getStringByUrl(String url) throws IOException {
        StatusLine st;
        block3: {
            String string;
            InputStream in = null;
            AbstractExecutionAwareRequest httpGet = null;
            try {
                httpGet = new HttpGet(url);
                CloseableHttpResponse response = this.getResponse((HttpRequestBase)httpGet);
                st = response.getStatusLine();
                if (200 != response.getStatusLine().getStatusCode()) break block3;
                in = response.getEntity().getContent();
                string = IOUtils.toString(in, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                httpGet.abort();
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            httpGet.abort();
            IOUtils.closeQuietly(in);
            return string;
        }
        throw new IOException(String.format("code %s phrase %s %s", st.getStatusCode(), st.getReasonPhrase(), url));
    }

    private RequestMetadata getMetadata(String url) throws IOException {
        RequestMetadata request = new RequestMetadata();
        HttpHead httpUrl = new HttpHead(url);
        CloseableHttpResponse response = this.getResponse(httpUrl);
        if (response.containsHeader(Headers.ETAG.getValue())) {
            request.setETag(response.getFirstHeader(Headers.ETAG.getValue()).getValue().replaceAll("\"", ""));
        } else {
            request.setETag(null);
        }
        if (response.containsHeader(Headers.LASTMODIFIED.getValue())) {
            request.setLastModified(response.getFirstHeader(Headers.LASTMODIFIED.getValue()).getValue().replaceAll("\"", ""));
        } else {
            request.setLastModified(null);
        }
        if (response.containsHeader(Headers.CONTENTLENGTH.getValue())) {
            request.setContentLength(response.getFirstHeader(Headers.CONTENTLENGTH.getValue()).getValue());
        } else {
            request.setContentLength(null);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestMetadata getResourseByUrl(String url, Path path) throws IOException, SocketTimeoutException {
        HttpGet httpGet = new HttpGet(url);
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        if (!path.toFile().getParentFile().exists()) {
            path.toFile().getParentFile().mkdirs();
        }
        Path temp = Paths.get(path.toAbsolutePath().toString() + ".temp", new String[0]);
        try {
            CloseableHttpResponse response = this.getResponse(httpGet);
            StatusLine st = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new IOException(String.format("code %s phrase %s", st.getStatusCode(), st.getReasonPhrase()));
            }
            in = new BufferedInputStream(entity.getContent());
            out = new BufferedOutputStream(new FileOutputStream(temp.toFile()));
            byte[] buffer = new byte[65536];
            int curread = in.read(buffer);
            while (curread != -1) {
                out.write(buffer, 0, curread);
                curread = in.read(buffer);
            }
        }
        catch (Throwable throwable) {
            httpGet.abort();
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        httpGet.abort();
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        Files.move(Paths.get(temp.toString(), new String[0]), path.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
        return this.getMetadata(url);
    }

    private CloseableHttpResponse getResponse(HttpRequestBase http) throws IOException {
        http.setConfig(this.requestConfig);
        return this.httpclient.execute(http);
    }

    public HttpServiceImpl(String proxy, CloseableHttpClient httpclient, RequestConfig requestConfig, int maxAttepmts) {
        this.proxy = proxy;
        this.httpclient = httpclient;
        this.requestConfig = requestConfig;
        this.maxAttepmts = maxAttepmts;
    }
}

