/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.versions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableMenuItem;
import org.tlauncher.tlauncher.ui.versions.VersionHandler;
import org.tlauncher.tlauncher.ui.versions.VersionHandlerListener;
import org.tlauncher.tlauncher.ui.versions.VersionList;

public class VersionRemoveButton
extends ImageUdaterButton
implements VersionHandlerListener,
Blockable {
    private static final long serialVersionUID = 427368162418879141L;
    private static final String ILLEGAL_SELECTION_BLOCK = "illegal-selection";
    private static final String PREFIX = "version.manager.delete.";
    private static final String ERROR = "version.manager.delete.error.";
    private static final String ERROR_TITLE = "version.manager.delete.error.title";
    private static final String MENU = "version.manager.delete.menu.";
    private final VersionHandler handler;
    private final JPopupMenu menu;
    private final LocalizableMenuItem onlyJar;
    private final LocalizableMenuItem withLibraries;
    private boolean libraries;

    VersionRemoveButton(VersionList list) {
        super(Color.WHITE, "delete-version.png");
        this.handler = list.handler;
        this.handler.addListener(this);
        this.menu = new JPopupMenu();
        this.onlyJar = new LocalizableMenuItem("version.manager.delete.menu.jar");
        this.onlyJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRemoveButton.this.onChosen(false);
            }
        });
        this.menu.add(this.onlyJar);
        this.withLibraries = new LocalizableMenuItem("version.manager.delete.menu.libraries");
        this.withLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRemoveButton.this.onChosen(true);
            }
        });
        this.menu.add(this.withLibraries);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRemoveButton.this.onChosen(false);
            }
        });
    }

    void onPressed() {
        this.menu.show(this, 0, this.getHeight());
    }

    void onChosen(boolean removeLibraries) {
        this.libraries = removeLibraries;
        this.handler.thread.deleteThread.iterate();
    }

    void delete() {
        if (this.handler.selected != null) {
            LocalVersionList localList = this.handler.vm.getLocalList();
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            for (VersionSyncInfo version : this.handler.selected) {
                if (!version.isInstalled()) continue;
                try {
                    localList.deleteVersion(version.getID(), this.libraries);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
            if (!errors.isEmpty()) {
                String title = Localizable.get(ERROR_TITLE);
                String message = Localizable.get(ERROR + (errors.size() == 1 ? "single" : "multiply"), errors);
                Alert.showError(title, message);
            }
        }
        this.handler.refresh();
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
        boolean onlyRemote = true;
        for (VersionSyncInfo version : versions) {
            if (!version.isInstalled()) continue;
            onlyRemote = false;
            break;
        }
        Blocker.setBlocked(this, ILLEGAL_SELECTION_BLOCK, onlyRemote);
    }

    @Override
    public void onVersionDeselected() {
        Blocker.block(this, ILLEGAL_SELECTION_BLOCK);
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

