/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.extended;

import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.tlauncher.tlauncher.ui.TLauncherFrame;
import org.tlauncher.tlauncher.ui.converter.StringConverter;
import org.tlauncher.tlauncher.ui.swing.DefaultConverterCellRenderer;
import org.tlauncher.tlauncher.ui.swing.SimpleComboBoxModel;
import org.tlauncher.tlauncher.ui.swing.box.TlauncherCustomBox;
import org.tlauncher.util.Reflect;

public class ExtendedComboBox<T>
extends TlauncherCustomBox<T> {
    private static final long serialVersionUID = -4509947341182373649L;
    private StringConverter<T> converter;

    public ExtendedComboBox(ListCellRenderer<T> renderer) {
        this.setModel(new SimpleComboBoxModel());
        this.setRenderer(renderer);
        this.setOpaque(false);
        this.setFont(this.getFont().deriveFont(TLauncherFrame.fontSize));
        Reflect.cast(this.getEditor().getEditorComponent(), JComponent.class).setOpaque(false);
    }

    public ExtendedComboBox(StringConverter<T> converter) {
        this(new DefaultConverterCellRenderer<T>(converter));
        this.converter = converter;
    }

    public ExtendedComboBox() {
        this((ListCellRenderer)null);
    }

    public SimpleComboBoxModel<T> getSimpleModel() {
        return (SimpleComboBoxModel)this.getModel();
    }

    public T getValueAt(int i) {
        Object value = this.getItemAt(i);
        return this.returnAs(value);
    }

    public T getSelectedValue() {
        Object selected = this.getSelectedItem();
        return this.returnAs(selected);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(value);
    }

    public void setSelectedValue(String string) {
        T value = this.convert(string);
        if (value == null) {
            return;
        }
        this.setSelectedValue(value);
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<T> converter) {
        this.converter = converter;
    }

    protected String convert(T obj) {
        T from = this.returnAs(obj);
        if (this.converter != null) {
            return this.converter.toValue(from);
        }
        return from == null ? null : from.toString();
    }

    protected T convert(String from) {
        if (this.converter == null) {
            return null;
        }
        return this.converter.fromString(from);
    }

    private T returnAs(Object obj) {
        try {
            return (T)obj;
        }
        catch (ClassCastException ce) {
            return null;
        }
    }
}

