/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.tlauncher.tlauncher.entity.hot.AdditionalHotServer;
import org.tlauncher.tlauncher.entity.hot.HotBanner;
import org.tlauncher.tlauncher.managers.popup.menu.HotServerManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.BackgroundPanel;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.button.RoundImageButton;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.menu.PopupMenuView;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.swing.FontTL;

public class AdditionalHostServerScene
extends PseudoScene {
    private static final long serialVersionUID = 8975208936840346013L;
    private final PopupMenuView popupMenuView;
    private final HotServerManager hotServerManager = (HotServerManager)TLauncher.getInjector().getInstance(HotServerManager.class);
    private final Integer rowHeight = 48;
    private boolean loadOnce;
    private JTable table;
    private JButton back;
    private JLabel serverTitle;

    public AdditionalHostServerScene(MainPane mp) {
        super(mp);
        BackgroundPanel panel = new BackgroundPanel("hot/hot-servers-background.png");
        panel.setSize(MainPane.SIZE.width, MainPane.SIZE.height);
        panel.setLocation(0, 0);
        this.add((Component)panel);
        this.popupMenuView = new PopupMenuView(this);
        this.back = new RoundImageButton(ImageCache.getImage((String)"hot/back.png"), ImageCache.getImage((String)"hot/back-active.png"));
        this.back.setBorder(BorderFactory.createEmptyBorder());
        this.serverTitle = new LocalizableLabel("server.page.title");
        this.table = new JTable();
        this.table.setRowHeight(this.rowHeight);
        this.table.setBorder(BorderFactory.createEmptyBorder());
        this.table.setOpaque(false);
        this.table.setShowGrid(false);
        this.table.getColumnModel().setColumnSelectionAllowed(true);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        SwingUtil.changeFontFamily(this.serverTitle, FontTL.ROBOTO_MEDIUM, 20);
        this.serverTitle.setForeground(Color.WHITE);
        this.add((Component)this.back);
        this.add((Component)this.serverTitle);
        this.add((Component)this.table);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AdditionalHostServerScene.this.prepare();
            }
        });
        this.back.addActionListener(e -> mp.setScene(mp.defaultScene));
        RollOverListener lst = new RollOverListener(this.table);
        this.table.addMouseMotionListener(lst);
        this.table.addMouseListener(lst);
        this.popupMenuView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AdditionalHostServerScene.this.table.clearSelection();
            }
        });
    }

    public void prepare() {
        this.prepareRemoteServerData(this.hotServerManager.getAdditionalHotServers().getList());
        if (this.loadOnce) {
            return;
        }
        this.loadOnce = true;
        int rows = this.hotServerManager.getAdditionalHotServers().getList().size();
        this.table.setSize(672, rows * this.rowHeight);
        this.back.setSize(new Dimension(187, 30));
        this.serverTitle.setSize(new Dimension(200, 24));
        this.table.setLocation(187, (MainPane.SIZE.height - rows * this.rowHeight) / 2);
        this.back.setLocation(200, this.table.getLocation().y - 26);
        this.serverTitle.setLocation(630, this.table.getLocation().y - 24);
        this.table.setModel(new TableModel(this.hotServerManager.getAdditionalHotServers().getList()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(632);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new AdditionalServerRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new Column1Renderer());
        AsyncThread.execute(() -> {
            try {
                HotBanner down;
                HotBanner up = this.hotServerManager.getAdditionalHotServers().getUpBanner();
                if (Objects.nonNull(up)) {
                    RoundImageButton upButton = new RoundImageButton(up.getImage(), up.getMouseOnImage());
                    SwingUtilities.invokeLater(() -> {
                        upButton.setSize(upButton.getImageSize());
                        this.add((Component)upButton);
                        upButton.setLocation(851, this.table.getLocation().y + 1);
                        upButton.addActionListener(e -> OS.openLink(up.getClickLink()));
                    });
                }
                if (Objects.nonNull(down = this.hotServerManager.getAdditionalHotServers().getDownBanner())) {
                    RoundImageButton downButton = new RoundImageButton(down.getImage(), down.getMouseOnImage());
                    SwingUtilities.invokeLater(() -> {
                        this.add((Component)downButton);
                        downButton.setSize(downButton.getImageSize());
                        downButton.setLocation(20, this.table.getLocation().y + this.table.getSize().height - downButton.getPreferredSize().height);
                        downButton.addActionListener(e -> OS.openLink(down.getClickLink()));
                    });
                }
            }
            catch (RuntimeException e) {
                U.log(e);
            }
            SwingUtilities.invokeLater(() -> this.add((Component)this.popupMenuView));
        });
    }

    private void prepareRemoteServerData(List<AdditionalHotServer> list) {
        int i = 0;
        while (i < list.size()) {
            int finalI = i++;
            AsyncThread.execute(() -> {
                AdditionalHotServer s = (AdditionalHotServer)list.get(finalI);
                try {
                    if (Objects.nonNull(s.getUpdated()) && s.getUpdated().after(new Date())) {
                        return;
                    }
                    this.hotServerManager.fillServer(s);
                    ((TableModel)this.table.getModel()).fireTableCellUpdated(finalI, 0);
                }
                catch (Throwable e) {
                    U.log(s, e);
                }
            });
        }
    }

    public PopupMenuView getPopupMenuView() {
        return this.popupMenuView;
    }

    private class RollOverListener
    extends MouseInputAdapter {
        JTable table;

        RollOverListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!AdditionalHostServerScene.this.popupMenuView.isVisible()) {
                this.table.clearSelection();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = this.table.rowAtPoint(e.getPoint());
            int column = this.table.columnAtPoint(e.getPoint());
            if (this.table.getSelectedRow() != row || this.table.getSelectedColumn() != column) {
                this.table.changeSelection(row, column, false, false);
            }
            if (row == -1 && this.table.getSelectedRow() > -1) {
                this.table.clearSelection();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = this.table.rowAtPoint(e.getPoint());
            int col = this.table.columnAtPoint(e.getPoint());
            if (row >= 0 && col >= 0) {
                Object value = this.table.getModel().getValueAt(row, col);
                if (col == 1) {
                    if (Objects.nonNull(value)) {
                        OS.openLink((String)value);
                    }
                } else if (e.getPoint().getX() < 490.0) {
                    AdditionalHotServer s = (AdditionalHotServer)value;
                    AdditionalHostServerScene.this.hotServerManager.processingEvent(s.getServerId());
                }
            }
        }
    }

    private class Column1Renderer
    implements TableCellRenderer {
        private Column1Renderer() {
        }

        private Component get(Object value, boolean active) {
            if (Objects.isNull(value)) {
                return new JLabel();
            }
            JLabel label = active ? new JLabel((Icon)ImageCache.getIcon((String)"hot/hot-server-site-active.png")) : new JLabel((Icon)ImageCache.getIcon((String)"hot/hot-server-site.png"));
            return label;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.get(value, isSelected);
        }
    }

    private class AdditionalServerRenderer
    extends DefaultTableCellRenderer {
        private AdditionalServerRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            BackgroundPanel panel;
            AdditionalHotServer s = (AdditionalHotServer)value;
            if (Objects.isNull(s)) {
                return null;
            }
            int gap = 0;
            if (isSelected) {
                panel = new BackgroundPanel(String.format("hot/%s-hot-servers-active.png", s.getImageNumber()));
                gap = 1;
            } else {
                panel = new BackgroundPanel(String.format("hot/%s-hot-servers.png", s.getImageNumber()));
            }
            panel.setBorder(BorderFactory.createEmptyBorder());
            JLabel shortDesc = new JLabel(s.getShortDescription());
            JLabel desc = new JLabel(s.getAddDescription());
            LocalizableLabel onlineTitle = new LocalizableLabel("server.page.online");
            LocalizableLabel versionTitle = new LocalizableLabel("version.release");
            JLabel online = new JLabel(s.getOnline() == -1 ? "???" : s.getOnline() + "/" + s.getMax());
            JLabel startVersion = new JLabel(s.getVersionDescription());
            SpringLayout spring = new SpringLayout();
            panel.setLayout(spring);
            if (!isSelected) {
                JLabel image = Objects.nonNull(s.getImage()) ? new JLabel(new ImageIcon(s.getImage().getScaledInstance(44, 44, 4))) : new JLabel((Icon)ImageCache.getIcon((String)"hot/tl-icon.png"));
                spring.putConstraint("West", (Component)image, 1, "West", (Component)panel);
                spring.putConstraint("East", (Component)image, 45, "West", (Component)panel);
                spring.putConstraint("North", (Component)image, 1, "North", (Component)panel);
                spring.putConstraint("South", (Component)image, -1, "South", (Component)panel);
                panel.add(image);
            }
            spring.putConstraint("West", (Component)shortDesc, -564, "East", (Component)panel);
            spring.putConstraint("East", (Component)shortDesc, -144, "East", (Component)panel);
            spring.putConstraint("North", (Component)shortDesc, gap, "North", (Component)panel);
            spring.putConstraint("South", (Component)shortDesc, gap + 24, "North", (Component)panel);
            panel.add(shortDesc);
            spring.putConstraint("West", (Component)desc, -564, "East", (Component)panel);
            spring.putConstraint("East", (Component)desc, -144, "East", (Component)panel);
            spring.putConstraint("North", (Component)desc, gap + 26, "North", (Component)panel);
            spring.putConstraint("South", (Component)desc, -gap - 2, "South", (Component)panel);
            panel.add(desc);
            spring.putConstraint("West", (Component)onlineTitle, -142, "East", (Component)panel);
            spring.putConstraint("East", (Component)onlineTitle, -62, "East", (Component)panel);
            spring.putConstraint("North", (Component)onlineTitle, gap, "North", (Component)panel);
            spring.putConstraint("South", (Component)onlineTitle, gap + 24, "North", (Component)panel);
            panel.add(onlineTitle);
            spring.putConstraint("West", (Component)online, -142, "East", (Component)panel);
            spring.putConstraint("East", (Component)online, -62, "East", (Component)panel);
            spring.putConstraint("North", (Component)online, gap + 26, "North", (Component)panel);
            spring.putConstraint("South", (Component)online, gap + 46, "North", (Component)panel);
            panel.add(online);
            spring.putConstraint("West", (Component)versionTitle, -60, "East", (Component)panel);
            spring.putConstraint("East", (Component)versionTitle, 0, "East", (Component)panel);
            spring.putConstraint("North", (Component)versionTitle, gap, "North", (Component)panel);
            spring.putConstraint("South", (Component)versionTitle, gap + 24, "North", (Component)panel);
            panel.add(versionTitle);
            spring.putConstraint("West", (Component)startVersion, -60, "East", (Component)panel);
            spring.putConstraint("East", (Component)startVersion, 0, "East", (Component)panel);
            spring.putConstraint("North", (Component)startVersion, gap + 26, "North", (Component)panel);
            spring.putConstraint("South", (Component)startVersion, gap + 46, "North", (Component)panel);
            panel.add(startVersion);
            onlineTitle.setHorizontalAlignment(0);
            versionTitle.setHorizontalAlignment(0);
            online.setHorizontalAlignment(0);
            startVersion.setHorizontalAlignment(0);
            SwingUtil.changeFontFamily(shortDesc, FontTL.ROBOTO_BOLD, 16);
            SwingUtil.changeFontFamily(desc, FontTL.ROBOTO_REGULAR, 12);
            SwingUtil.changeFontFamily(onlineTitle, FontTL.ROBOTO_BOLD, 12);
            SwingUtil.changeFontFamily(versionTitle, FontTL.ROBOTO_BOLD, 12);
            SwingUtil.changeFontFamily(online, FontTL.ROBOTO_MEDIUM, 12);
            SwingUtil.changeFontFamily(startVersion, FontTL.ROBOTO_MEDIUM, 12);
            shortDesc.setForeground(Color.WHITE);
            desc.setForeground(Color.WHITE);
            onlineTitle.setForeground(Color.WHITE);
            versionTitle.setForeground(Color.WHITE);
            online.setForeground(Color.WHITE);
            startVersion.setForeground(Color.WHITE);
            if (isSelected) {
                return panel;
            }
            JPanel jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(1, 13, 1, 0));
            jPanel.add((Component)panel, "Center");
            jPanel.setOpaque(false);
            return jPanel;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private List<AdditionalHotServer> list;

        TableModel(List<AdditionalHotServer> list) {
            this.list = list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.list.get(row);
            }
            return this.list.get(row).getTMonitoringLink();
        }
    }
}

