/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import by.gdev.http.download.service.FileCacheService;
import by.gdev.util.DesktopUtil;
import by.gdev.util.model.download.Metadata;
import by.gdev.util.model.download.Repo;
import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.PictureType;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.modpack.BigPictureObserver;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.renderer.PictureListRenderer;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;

public class PicturePanel
extends ExtendedPanel {
    private JButton previousPicture;
    private JButton nextPicture;
    private JList<ImageIcon> list = new JList();
    private final int WIDHT_BUTTON = 64;
    private int current;
    private Dimension buttonSize = new Dimension(64, 155);
    private List<ImageIcon> cache = Collections.synchronizedList(new ArrayList());
    private LocalizableLabel downloadingLabel;
    private ExecutorService executorService;

    public PicturePanel(final GameEntityDTO g, final GameType type) {
        Injector inj = TLauncher.getInjector();
        final ModpackManager m = (ModpackManager)inj.getInstance(ModpackManager.class);
        this.executorService = (ExecutorService)inj.getInstance(ExecutorService.class);
        final FileCacheService fileCacheService = (FileCacheService)inj.getInstance(FileCacheService.class);
        this.setPreferredSize(new Dimension(1050, 318));
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.previousPicture = new ImageUdaterButton(Color.WHITE, Color.WHITE, "previous-arrow.png", "previous-arrow-under.png");
        this.nextPicture = new ImageUdaterButton(Color.WHITE, Color.WHITE, "next-arrow.png", "next-arrow-under.png");
        this.downloadingLabel = new LocalizableLabel("loginform.loading");
        this.downloadingLabel.setHorizontalAlignment(0);
        this.downloadingLabel.setVerticalAlignment(0);
        SwingUtil.setFontSize(this.downloadingLabel, 16.0f);
        this.list.setPreferredSize(new Dimension(ModpackScene.SIZE.width - 128, 190));
        this.list.setOpaque(false);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(1);
        this.nextPicture.setPreferredSize(this.buttonSize);
        this.previousPicture.setPreferredSize(this.buttonSize);
        this.list.setCellRenderer(new PictureListRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PicturePanel.this.list.getModel().getSize() > 0 && PicturePanel.this.current != -1) {
                    BigPictureObserver pictureObserver = new BigPictureObserver(TLauncher.getInstance().getFrame(), "", PicturePanel.this.current + PicturePanel.this.list.locationToIndex(e.getPoint()), type, g);
                    pictureObserver.setVisible(true);
                }
            }
        });
        this.previousPicture.setOpaque(false);
        this.nextPicture.setOpaque(false);
        this.nextPicture.addActionListener(e -> this.updateNext());
        this.previousPicture.addActionListener(e -> this.updatePrevious());
        this.add((Component)this.downloadingLabel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (!PicturePanel.this.contains(PicturePanel.this.downloadingLabel)) {
                    return;
                }
                CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                    Repo pictures = m.getGameEntitiesPictures(type, g.getId(), PictureType.SMALL);
                    if (!pictures.getResources().isEmpty()) {
                        List<CompletableFuture> list = pictures.getResources().stream().map(m -> CompletableFuture.runAsync(() -> {
                            try {
                                PicturePanel.this.cache.add(new ImageIcon(Files.readAllBytes(fileCacheService.getRawObject(pictures.getRepositories(), (Metadata)m, true))));
                            }
                            catch (Exception e1) {
                                U.log(e1);
                            }
                        }, PicturePanel.this.executorService)).collect(Collectors.toList());
                        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).get();
                    }
                    PicturePanel.this.afterDownload();
                    return null;
                })).exceptionally(t -> {
                    U.log(t);
                    return null;
                });
            }
        });
    }

    private void afterDownload() {
        SwingUtilities.invokeLater(() -> {
            if (this.cache.size() == 1) {
                this.list.setBorder(BorderFactory.createEmptyBorder(64, 304, 0, 0));
            } else {
                this.list.setBorder(BorderFactory.createEmptyBorder(64, 0, 0, 0));
            }
            if (this.cache.size() > 3) {
                this.add((Component)this.previousPicture, "West");
                this.add((Component)this.nextPicture, "East");
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(0, 64, 0, 64));
            }
            this.remove(this.downloadingLabel);
            if (this.cache.isEmpty()) {
                LocalizableLabel l = new LocalizableLabel("modpack.complete.picture.empty");
                l.setHorizontalAlignment(0);
                l.setVerticalAlignment(0);
                SwingUtil.setFontSize(l, 16.0f);
                this.add((Component)l, "Center");
            } else {
                this.add(this.list, "Center");
                this.updateData();
            }
            this.revalidate();
            this.repaint();
        });
    }

    private void updateNext() {
        int enable = this.cache.size() - 3 - this.current;
        if (enable > 0) {
            ++this.current;
            this.updateData();
        }
    }

    private void updatePrevious() {
        if (this.current > 0) {
            --this.current;
            this.updateData();
        }
    }

    private void updateData() {
        DefaultListModel<ImageIcon> page = new DefaultListModel<ImageIcon>();
        int i = this.current;
        for (int j = 0; i < this.cache.size() && j < 3; ++i, ++j) {
            page.addElement(this.cache.get(i));
        }
        this.list.setModel(page);
        this.nextPicture.setPreferredSize(this.buttonSize);
        this.previousPicture.setPreferredSize(this.buttonSize);
        this.repaint();
    }
}

