/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.login.AccountComboBox;
import org.tlauncher.tlauncher.ui.login.CheckBoxPanel;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.login.UsernameField;
import org.tlauncher.tlauncher.ui.login.VersionComboBox;
import org.tlauncher.tlauncher.ui.swing.extended.VPanel;

public class InputPanel
extends VPanel {
    private static final long serialVersionUID = -4418780541141471184L;
    public final LoginForm loginForm;
    public final UsernameField username;
    public final VersionComboBox version;
    public final CheckBoxPanel checkbox;
    public final AccountComboBox accountComboBox;
    private Account.AccountType type;

    public InputPanel(LoginForm lf) {
        boolean chooser = TLauncher.getInstance().getConfiguration().getBoolean("chooser.type.account");
        this.loginForm = lf;
        this.username = new UsernameField("test");
        this.accountComboBox = new AccountComboBox(lf);
        if (chooser) {
            this.add((Component)this.accountComboBox, Box.createRigidArea(new Dimension(1, 3)));
            this.type = Account.AccountType.MOJANG;
            lf.addLoginProcessListener(this.accountComboBox);
        } else {
            this.add((Component)this.username, Box.createRigidArea(new Dimension(1, 3)));
            this.type = Account.AccountType.FREE;
            lf.addLoginProcessListener(this.username);
        }
        this.version = new VersionComboBox(lf);
        this.add((Component)this.version);
        this.checkbox = new CheckBoxPanel(lf, this, chooser);
        this.add((Component)this.checkbox);
        this.add((Component)new JButton("test"));
    }

    public void changeTypeAccount(Account.AccountType type) {
        if (type.equals((Object)Account.AccountType.SPECIAL)) {
            if (this.contains(this.username)) {
                this.remove(this.username);
            }
            this.add((Component)this.accountComboBox, 0);
            this.loginForm.addLoginProcessListener(this.accountComboBox);
            this.loginForm.removeLoginProcessListener(this.username);
            this.type = Account.AccountType.SPECIAL;
        } else {
            if (this.contains(this.accountComboBox)) {
                this.remove(this.accountComboBox);
            }
            this.add((Component)this.username, 0);
            this.loginForm.addLoginProcessListener(this.username);
            this.loginForm.removeLoginProcessListener(this.accountComboBox);
            this.type = Account.AccountType.FREE;
        }
        this.revalidate();
        this.repaint();
    }

    public String getUsername() {
        if (this.type.equals((Object)Account.AccountType.FREE)) {
            return this.username.getUsername();
        }
        return ((Account)this.accountComboBox.getSelectedItem()).getUsername();
    }

    public Account.AccountType getTypeAccountShow() {
        return this.type;
    }
}

