/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.user.xb.auth;

import java.io.IOException;
import java.util.Locale;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.tlauncher.tlauncher.minecraft.user.HttpClientRequester;
import org.tlauncher.tlauncher.minecraft.user.InvalidResponseException;
import org.tlauncher.tlauncher.minecraft.user.MicrosoftOAuthToken;
import org.tlauncher.tlauncher.minecraft.user.Requester;
import org.tlauncher.tlauncher.minecraft.user.oauth.OAuthApplication;
import org.tlauncher.tlauncher.minecraft.user.xb.XboxServiceAuthStrategy;
import org.tlauncher.tlauncher.minecraft.user.xb.XboxServiceAuthenticationResponse;
import org.tlauncher.tlauncher.minecraft.user.xb.auth.XboxLiveAuthenticationException;

public class XboxLiveAuthenticator
extends XboxServiceAuthStrategy {
    private static final Logger LOGGER = LogManager.getLogger(XboxLiveAuthenticator.class);

    public XboxLiveAuthenticator(OAuthApplication application) {
        super(LOGGER, new HttpClientRequester<String>(accessToken -> Request.Post((String)"https://user.auth.xboxlive.com/user/authenticate").bodyString(String.format(Locale.ROOT, "{\"Properties\":{\"AuthMethod\":\"RPS\",\"SiteName\":\"user.auth.xboxlive.com\",\"RpsTicket\":\"%s\"},\"RelyingParty\":\"http://auth.xboxlive.com\",\"TokenType\":\"JWT\"}", (application.isUseWeirdXboxTokenPrefix() ? "d=" : "") + accessToken), ContentType.APPLICATION_JSON)));
    }

    XboxLiveAuthenticator(Requester<String> requester) {
        super(LOGGER, requester);
    }

    public XboxServiceAuthenticationResponse xboxLiveAuthenticate(String accessToken) throws XboxLiveAuthenticationException, IOException {
        try {
            return (XboxServiceAuthenticationResponse)this.requestAndParse(accessToken);
        }
        catch (InvalidResponseException e) {
            throw new XboxLiveAuthenticationException(e);
        }
    }

    public XboxServiceAuthenticationResponse xboxLiveAuthenticate(MicrosoftOAuthToken token) throws XboxLiveAuthenticationException, IOException {
        return this.xboxLiveAuthenticate(token.getAccessToken());
    }
}

