/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.auth;

import com.google.common.collect.Sets;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.tlauncher.tlauncher.minecraft.auth.GameProfile;
import org.tlauncher.tlauncher.minecraft.auth.UUIDTypeAdapter;
import org.tlauncher.tlauncher.minecraft.auth.User;
import org.tlauncher.tlauncher.minecraft.auth.UserProperty;
import org.tlauncher.tlauncher.minecraft.user.MicrosoftOAuthToken;
import org.tlauncher.tlauncher.minecraft.user.mcsauth.MinecraftServicesToken;
import org.tlauncher.util.Reflect;

public class Account {
    private String username;
    private String userID;
    private String displayName;
    private String password;
    private String accessToken;
    private MicrosoftOAuthToken microsoftOAuthToken;
    private MinecraftServicesToken minecraftServicesToken;
    private String uuid;
    private List<Map<String, String>> userProperties;
    private AccountType type = AccountType.TLAUNCHER;
    @Expose
    private boolean premiumAccount;
    private GameProfile[] profiles;
    private GameProfile selectedProfile;
    private User user;

    public Account() {
    }

    public Account(String username) {
        this();
        this.setUsername(username);
    }

    public Account(Map<String, Object> map) {
        this();
        this.fillFromMap(map);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.username : this.displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccessToken() {
        if (this.type.equals((Object)AccountType.MICROSOFT) && Objects.nonNull(this.minecraftServicesToken)) {
            return this.minecraftServicesToken.getAccessToken();
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        if ("null".equals(accessToken)) {
            accessToken = null;
        }
        this.accessToken = accessToken;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public GameProfile[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(GameProfile[] p) {
        this.profiles = p;
    }

    public GameProfile getProfile() {
        return this.selectedProfile != null ? this.selectedProfile : GameProfile.DEFAULT_PROFILE;
    }

    public void setProfile(GameProfile p) {
        this.selectedProfile = p;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Map<String, List<String>> getProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<UserProperty> list = new ArrayList<UserProperty>();
        if (this.userProperties != null) {
            for (Map<String, String> properties : this.userProperties) {
                list.add(new UserProperty(properties.get("name"), properties.get("value")));
            }
        }
        if (this.user != null && this.user.getProperties() != null) {
            for (Map<String, String> properties : this.user.getProperties()) {
                list.add(new UserProperty(properties.get("name"), properties.get("value")));
            }
        }
        for (UserProperty property : list) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(property.getValue());
            map.put(property.getKey(), values);
        }
        return map;
    }

    void setProperties(List<Map<String, String>> properties) {
        this.userProperties = properties;
    }

    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public boolean isFree() {
        return this.type.equals((Object)AccountType.FREE);
    }

    Map<String, Object> createMap() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("username", this.username);
        r.put("userid", this.userID);
        r.put("uuid", UUIDTypeAdapter.toUUID(this.uuid));
        r.put("displayName", this.displayName);
        if (!this.isFree()) {
            r.put("type", (Object)this.type);
            r.put("accessToken", this.accessToken);
        }
        if (this.userProperties != null) {
            r.put("userProperties", this.userProperties);
        }
        return r;
    }

    void fillFromMap(Map<String, Object> map) {
        if (map.containsKey("username")) {
            this.setUsername(map.get("username").toString());
        }
        this.setUserID(map.containsKey("userid") ? map.get("userid").toString() : this.getUsername());
        this.setDisplayName(map.containsKey("displayName") ? map.get("displayName").toString() : this.getUsername());
        this.setProperties(map.containsKey("userProperties") ? (List)map.get("userProperties") : null);
        this.setUUID(map.containsKey("uuid") ? UUIDTypeAdapter.toUUID(map.get("uuid").toString()) : null);
        boolean hasAccessToken = map.containsKey("accessToken");
        if (hasAccessToken) {
            this.setAccessToken(map.get("accessToken").toString());
        }
        this.setType(map.containsKey("type") ? Reflect.parseEnum(AccountType.class, map.get("type").toString()) : (hasAccessToken ? AccountType.MOJANG : AccountType.FREE));
    }

    public static Account createFreeAccountByUsername(String username) {
        Account account = new Account();
        account.setUUID(UUIDTypeAdapter.fromUUID(UUID.randomUUID()));
        account.setUsername(username);
        account.setUserID(account.getUsername());
        account.setDisplayName(account.getUsername());
        account.setType(AccountType.FREE);
        return account;
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        Map<String, Object> map = this.createMap();
        if (map.containsKey("accessToken")) {
            map.remove("accessToken");
            map.put("accessToken", "(not null)");
        }
        return "Account" + map;
    }

    public static Account randomAccount() {
        return new Account("empty_manage " + new Random().nextLong());
    }

    public boolean isPremiumAccount() {
        return this.premiumAccount;
    }

    public void setPremiumAccount(boolean premiumAccount) {
        this.premiumAccount = premiumAccount;
    }

    public MicrosoftOAuthToken getMicrosoftOAuthToken() {
        return this.microsoftOAuthToken;
    }

    public void setMicrosoftOAuthToken(MicrosoftOAuthToken microsoftOAuthToken) {
        this.microsoftOAuthToken = microsoftOAuthToken;
    }

    public MinecraftServicesToken getMinecraftServicesToken() {
        return this.minecraftServicesToken;
    }

    public void setMinecraftServicesToken(MinecraftServicesToken minecraftServicesToken) {
        this.minecraftServicesToken = minecraftServicesToken;
    }

    public String getShortUUID() {
        return UUIDTypeAdapter.toUUID(this.uuid);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$userID = this.getUserID();
        String other$userID = other.getUserID();
        if (this$userID == null ? other$userID != null : !this$userID.equals(other$userID)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        MicrosoftOAuthToken this$microsoftOAuthToken = this.getMicrosoftOAuthToken();
        MicrosoftOAuthToken other$microsoftOAuthToken = other.getMicrosoftOAuthToken();
        if (this$microsoftOAuthToken == null ? other$microsoftOAuthToken != null : !((Object)this$microsoftOAuthToken).equals(other$microsoftOAuthToken)) {
            return false;
        }
        MinecraftServicesToken this$minecraftServicesToken = this.getMinecraftServicesToken();
        MinecraftServicesToken other$minecraftServicesToken = other.getMinecraftServicesToken();
        if (this$minecraftServicesToken == null ? other$minecraftServicesToken != null : !((Object)this$minecraftServicesToken).equals(other$minecraftServicesToken)) {
            return false;
        }
        String this$uuid = this.getUUID();
        String other$uuid = other.getUUID();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        List<Map<String, String>> this$userProperties = this.userProperties;
        List<Map<String, String>> other$userProperties = other.userProperties;
        if (this$userProperties == null ? other$userProperties != null : !((Object)this$userProperties).equals(other$userProperties)) {
            return false;
        }
        AccountType this$type = this.getType();
        AccountType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.isPremiumAccount() != other.isPremiumAccount()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProfiles(), other.getProfiles())) {
            return false;
        }
        GameProfile this$selectedProfile = this.selectedProfile;
        GameProfile other$selectedProfile = other.selectedProfile;
        if (this$selectedProfile == null ? other$selectedProfile != null : !((Object)this$selectedProfile).equals(other$selectedProfile)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $userID = this.getUserID();
        result = result * 59 + ($userID == null ? 43 : $userID.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        MicrosoftOAuthToken $microsoftOAuthToken = this.getMicrosoftOAuthToken();
        result = result * 59 + ($microsoftOAuthToken == null ? 43 : ((Object)$microsoftOAuthToken).hashCode());
        MinecraftServicesToken $minecraftServicesToken = this.getMinecraftServicesToken();
        result = result * 59 + ($minecraftServicesToken == null ? 43 : ((Object)$minecraftServicesToken).hashCode());
        String $uuid = this.getUUID();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        List<Map<String, String>> $userProperties = this.userProperties;
        result = result * 59 + ($userProperties == null ? 43 : ((Object)$userProperties).hashCode());
        AccountType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + (this.isPremiumAccount() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getProfiles());
        GameProfile $selectedProfile = this.selectedProfile;
        result = result * 59 + ($selectedProfile == null ? 43 : ((Object)$selectedProfile).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public static enum AccountType {
        TLAUNCHER,
        MOJANG,
        FREE,
        SPECIAL,
        MICROSOFT;

        public static Set<AccountType> OFFICIAL_ACCOUNTS;
        public static Set<AccountType> NONE_OFFICIAL_ACCOUNTS;

        static {
            OFFICIAL_ACCOUNTS = Sets.newHashSet((Object[])new AccountType[]{MOJANG, MICROSOFT});
            NONE_OFFICIAL_ACCOUNTS = Sets.newHashSet((Object[])new AccountType[]{TLAUNCHER, FREE});
        }
    }
}

