/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.gson.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.util.gson.serializer.ElementCollectionsPool;
import org.tlauncher.util.gson.serializer.MapDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ModDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ResourcePackDTOTypeAdapter;

public class ModpackDTOTypeAdapter
implements JsonSerializer<ModpackDTO>,
JsonDeserializer<ModpackDTO> {
    private Gson gson;

    public ModpackDTOTypeAdapter() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ModDTO.class), new ModDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)MapDTO.class), new MapDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourcePackDTO.class), new ResourcePackDTOTypeAdapter());
        builder.enableComplexMapKeySerialization();
        this.gson = builder.create();
    }

    @Override
    public ModpackDTO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        ModpackDTO dto = this.gson.fromJson(jsonElement, ModpackDTO.class);
        JsonObject object = jsonElement.getAsJsonObject();
        dto.setVersion(this.gson.fromJson(object.get("version"), ModpackVersionDTO.class));
        dto.setVersions((List)this.gson.fromJson(object.get("versions"), new TypeToken<List<ModpackVersionDTO>>(){}.getType()));
        ElementCollectionsPool.fill(dto);
        return dto;
    }

    @Override
    public JsonElement serialize(ModpackDTO modpackDTO, Type type, JsonSerializationContext jsonSerializationContext) {
        return this.gson.toJsonTree(modpackDTO);
    }
}

