/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.gson.serializer;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.CategoryDTO;
import org.tlauncher.modpack.domain.client.share.JavaEnum;
import org.tlauncher.modpack.domain.client.version.VersionDTO;

public class ElementCollectionsPool {
    private static final Map<String, String> stringElements = new HashMap<String, String>();
    private static final Map<Set<String>, Set<String>> set = new HashMap<Set<String>, Set<String>>();
    private static final Map<List<JavaEnum>, List<JavaEnum>> javaEnums = new HashMap<List<JavaEnum>, List<JavaEnum>>();
    private static final Map<List<CategoryDTO>, List<CategoryDTO>> categories = new HashMap<List<CategoryDTO>, List<CategoryDTO>>();

    public static void fill(GameEntityDTO en) {
        if (en.getVersions() == null) {
            return;
        }
        for (VersionDTO v : en.getVersions()) {
            List<JavaEnum> java;
            if (v.getGameVersions() != null) {
                HashSet<String> games = new HashSet<String>();
                for (String s : v.getGameVersions()) {
                    if (!stringElements.containsKey(s)) {
                        stringElements.put(s, s);
                        s = stringElements.get(s);
                    }
                    games.add(stringElements.get(s));
                }
                if (set.containsKey(games)) {
                    v.setGameVersions(Lists.newArrayList((Iterable)set.get(games)));
                } else {
                    v.setGameVersions(Lists.newArrayList(games));
                    set.put(games, games);
                }
            }
            if ((java = v.getJavaVersions()) != null) {
                if (javaEnums.containsKey(java)) {
                    v.setJavaVersions(javaEnums.get(java));
                } else {
                    javaEnums.put(java, java);
                }
            }
            List<CategoryDTO> listCategories = en.getCategories();
            listCategories.removeIf(e -> Objects.isNull(e));
            if (listCategories == null) continue;
            if (categories.containsKey(listCategories)) {
                en.setCategories(categories.get(listCategories));
                continue;
            }
            categories.put(listCategories, listCategories);
        }
    }
}

