/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.modpack.domain.client.ForgeVersionDTO;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;

public class CreationModpackForgeComboboxUI
extends BasicComboBoxUI {
    @Override
    protected JButton createArrowButton() {
        ImageUdaterButton button = new ImageUdaterButton(Color.WHITE, "gray-combobox-array.png");
        for (ActionListener l : button.getActionListeners()) {
            button.removeActionListener(l);
        }
        button.setModelPressedColor(ColorUtil.COLOR_195);
        return button;
    }

    @Override
    protected ComboPopup createPopup() {
        BasicComboPopup basic = new BasicComboPopup(this.comboBox){

            @Override
            protected JScrollPane createScroller() {
                ModpackScrollBarUI barUI = new ModpackScrollBarUI(){

                    @Override
                    protected Dimension getMinimumThumbSize() {
                        return new Dimension(10, 40);
                    }

                    @Override
                    public Dimension getMaximumSize(JComponent c) {
                        Dimension dim = super.getMaximumSize(c);
                        dim.setSize(10.0, dim.getHeight());
                        return dim;
                    }

                    @Override
                    public Dimension getPreferredSize(JComponent c) {
                        Dimension dim = super.getPreferredSize(c);
                        dim.setSize(13.0, dim.getHeight());
                        return dim;
                    }
                };
                barUI.setGapThubm(5);
                JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                scroller.getVerticalScrollBar().setUI(barUI);
                return scroller;
            }
        };
        basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(149, 149, 149)));
        return basic;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (Objects.isNull(this.comboBox.getSelectedItem())) {
            return;
        }
        g.setColor(Color.WHITE);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.paintText(g, bounds, ((ForgeVersionDTO)this.comboBox.getSelectedItem()).getName());
    }

    protected void paintText(Graphics g, Rectangle textRect, String text) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(text, g2d);
        g.setFont(this.comboBox.getFont());
        g.setColor(new Color(25, 25, 25));
        int x = 14;
        int y = (textRect.height - (int)r.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, x, y);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }
}

