/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.accounts.AccountEditor;
import org.tlauncher.tlauncher.ui.accounts.AccountList;
import org.tlauncher.tlauncher.ui.accounts.AccountTip;
import org.tlauncher.tlauncher.ui.accounts.helper.AccountEditorHelper;
import org.tlauncher.tlauncher.ui.accounts.helper.HelperState;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.server.BackPanel;
import org.tlauncher.tlauncher.ui.swing.FlexibleEditorPanel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;

public class AccountEditorScene
extends PseudoScene {
    private static final long serialVersionUID = -151325577614420989L;
    private final int WIDTH = 502;
    private final int HEIGHT = 365;
    public final AccountEditor editor;
    public final AccountList list;
    public final AccountTip tip;
    public final AccountEditorHelper helper;
    public final ExtendedPanel panel = new ExtendedPanel(new BorderLayout(0, 0));
    public static final Color BACKGROUND_ACCOUNT_COLOR = new Color(248, 246, 244);
    private final FlexibleEditorPanel flex = new FlexibleEditorPanel("text/html", "auth.tip.tlauncher", 477);
    private final ProfileManager profileManager;

    public AccountEditorScene(MainPane main) {
        super(main);
        ExtendedPanel middlePanel = new ExtendedPanel();
        this.profileManager = TLauncher.getInstance().getProfileManager();
        BackPanel backPanel = new BackPanel("account.config", new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    AccountEditorScene.this.profileManager.refresh();
                    AccountEditorScene.this.getMainPane().openDefaultScene();
                }
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        this.panel.setOpaque(true);
        this.panel.setSize(502, 365);
        this.flex.setPreferredSize(new Dimension(486, 99));
        this.flex.setMargin(new Insets(20, 20, 22, 16));
        backPanel.setPreferredSize(new Dimension(502, 25));
        this.panel.setBackground(BACKGROUND_ACCOUNT_COLOR);
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        middlePanel.setPreferredSize(new Dimension(502, 191));
        middlePanel.setInsets(new Insets(20, 20, 0, 16));
        ExtendedPanel separator = new ExtendedPanel(new FlowLayout(0, 0, 0));
        JPanel gap = new JPanel(new FlowLayout(1, 0, 0));
        gap.setPreferredSize(new Dimension(1, 170));
        gap.setBackground(new Color(172, 171, 170));
        separator.setPreferredSize(new Dimension(41, 171));
        separator.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        ((Container)separator).add(Box.createHorizontalStrut(20));
        ((Container)separator).add(gap);
        ((Container)separator).add(Box.createHorizontalStrut(20));
        this.editor = new AccountEditor(this, this.flex);
        this.editor.setOpaque(true);
        this.list = new AccountList(this);
        this.profileManager.addListener(this.list);
        middlePanel.add((Component)this.editor);
        middlePanel.add((Component)separator);
        middlePanel.add((Component)this.list);
        this.panel.add((Component)backPanel, "North");
        this.panel.add((Component)middlePanel, "Center");
        this.panel.add((Component)this.flex, "South");
        this.add((Component)this.panel);
        this.tip = new AccountTip(this);
        this.tip.setAccountType(Account.AccountType.TLAUNCHER);
        this.editor.setSelectedAccountType(Account.AccountType.TLAUNCHER);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AccountEditorScene.this.list.model.getSize() == 0) {
                    AccountEditorScene.this.list.addTempToList();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.tip.setVisible(true);
        this.helper = new AccountEditorHelper(this);
        this.add((Component)this.helper);
        this.helper.setState(HelperState.NONE);
    }

    public void setShownAccountHelper(boolean shown, boolean animate) {
        super.setShown(shown, animate);
        if (!shown || !this.list.model.isEmpty()) {
            this.helper.setState(HelperState.NONE);
        }
    }

    @Override
    public void onResize() {
        super.onResize();
        int hw = this.getWidth() / 2;
        int hh = this.getHeight() / 2;
        this.panel.setLocation(hw - this.panel.getWidth() / 2, hh - this.panel.getHeight() / 2);
    }
}

