/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.auth;

import java.io.IOException;
import java.util.Objects;
import org.tlauncher.tlauncher.exceptions.auth.AuthenticatorException;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.minecraft.auth.UUIDTypeAdapter;
import org.tlauncher.tlauncher.minecraft.user.MicrosoftOAuthExchangeCode;
import org.tlauncher.tlauncher.minecraft.user.MinecraftAuthenticationException;
import org.tlauncher.tlauncher.minecraft.user.MinecraftOAuthAuthenticate;
import org.tlauncher.tlauncher.minecraft.user.MinecraftProfileConverter;
import org.tlauncher.tlauncher.minecraft.user.MinecraftUser;
import org.tlauncher.tlauncher.minecraft.user.RedirectUrl;
import org.tlauncher.tlauncher.minecraft.user.gos.GameOwnershipValidator;
import org.tlauncher.tlauncher.minecraft.user.mcsauth.MinecraftServicesAuthenticator;
import org.tlauncher.tlauncher.minecraft.user.oauth.OAuthApplication;
import org.tlauncher.tlauncher.minecraft.user.oauth.exchange.MicrosoftOAuthCodeExchanger;
import org.tlauncher.tlauncher.minecraft.user.oauth.exchange.MicrosoftOAuthCodeExchangerImpl;
import org.tlauncher.tlauncher.minecraft.user.oauth.exchange.MicrosoftOAuthRefreshCodeExchangerIMpl;
import org.tlauncher.tlauncher.minecraft.user.preq.MinecraftProfileRequester;
import org.tlauncher.tlauncher.minecraft.user.xb.auth.XboxLiveAuthenticator;
import org.tlauncher.tlauncher.minecraft.user.xb.xsts.XSTSAuthenticator;
import org.tlauncher.util.U;

public class MicrosoftAuthenticator
extends Authenticator {
    public static final OAuthApplication microsoftAuth = OAuthApplication.TLAUNCHER_PARAMETERS;

    public MicrosoftAuthenticator(Account account) {
        super(account);
    }

    @Override
    protected void pass() throws AuthenticatorException {
        try {
            if (Objects.isNull(this.account.getAccessToken())) {
                MicrosoftOAuthCodeExchangerImpl microsoftOAuthCodeExchanger = new MicrosoftOAuthCodeExchangerImpl(microsoftAuth.getClientId(), microsoftAuth.getTokenURL());
                MicrosoftOAuthExchangeCode o = new MicrosoftOAuthExchangeCode(this.account.getPassword(), new RedirectUrl(microsoftAuth.getRedirectURL()));
                this.doRequest(microsoftOAuthCodeExchanger, o);
            } else if (this.account.getMicrosoftOAuthToken().isExpired()) {
                MicrosoftOAuthRefreshCodeExchangerIMpl microsoftOAuthCodeExchanger = new MicrosoftOAuthRefreshCodeExchangerIMpl(microsoftAuth.getClientId(), microsoftAuth.getTokenURL());
                MicrosoftOAuthExchangeCode o = new MicrosoftOAuthExchangeCode(this.account.getMicrosoftOAuthToken().getRefreshToken(), new RedirectUrl(microsoftAuth.getRedirectURL()));
                this.doRequest(microsoftOAuthCodeExchanger, o);
            }
        }
        catch (IOException | MinecraftAuthenticationException e) {
            U.log(e);
            throw new AuthenticatorException(e);
        }
    }

    private void doRequest(MicrosoftOAuthCodeExchanger microsoftOAuthCodeExchanger, MicrosoftOAuthExchangeCode payload) throws IOException, MinecraftAuthenticationException {
        XboxLiveAuthenticator xboxLiveAuthenticator = new XboxLiveAuthenticator(microsoftAuth);
        MinecraftOAuthAuthenticate minecraftOAuthAuthenticate = new MinecraftOAuthAuthenticate(microsoftOAuthCodeExchanger, xboxLiveAuthenticator, new XSTSAuthenticator(), new MinecraftServicesAuthenticator(), new GameOwnershipValidator(), new MinecraftProfileRequester(), new MinecraftProfileConverter());
        MinecraftUser user = minecraftOAuthAuthenticate.authenticate(payload);
        this.account.setUUID(UUIDTypeAdapter.toUUID(user.getUUID().toString()));
        this.account.setDisplayName(user.getDisplayName());
        this.account.setType(Account.AccountType.MICROSOFT);
        this.account.setMicrosoftOAuthToken(user.getMicrosoftToken());
        this.account.setMinecraftServicesToken(user.getMinecraftToken());
        this.account.setPassword(null);
    }
}

