/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.downloader;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.AbortedDownloadException;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.DownloadableHandler;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class Downloadable {
    private static final boolean DEFAULT_FORCE = false;
    private static final boolean DEFAULT_FAST = false;
    private final List<File> additionalDestinations = Collections.synchronizedList(new ArrayList());
    private final List<DownloadableHandler> handlers = Collections.synchronizedList(new ArrayList());
    private Repo repo;
    private MetadataDTO metadataDTO;
    private boolean forceDownload;
    private boolean fastDownload;
    private boolean locked;
    private DownloadableContainer container;
    private long alreadyDownloaded;
    private Throwable error;

    public Downloadable(Repo repo, MetadataDTO metadataDTO, boolean forceDownload, boolean fastDownload) {
        this();
        String unb = TLauncher.getInnerSettings().getArray("file.server")[1];
        if (metadataDTO.getUrl().startsWith(unb)) {
            this.metadataDTO = new MetadataDTO();
            this.metadataDTO.setSha1(metadataDTO.getSha1());
            this.metadataDTO.setSize(metadataDTO.getSize());
            this.metadataDTO.setLocalDestination(metadataDTO.getLocalDestination());
            this.metadataDTO.setPath(metadataDTO.getPath());
            this.metadataDTO.setUrl(metadataDTO.getUrl().replace(unb, ""));
            this.setRepo(ClientInstanceRepo.createModpackRepo());
        } else {
            this.metadataDTO = metadataDTO;
            this.setRepo(repo);
        }
        this.forceDownload = forceDownload;
        this.fastDownload = fastDownload;
    }

    public Downloadable(Repo repo, MetadataDTO metadataDTO, boolean forceDownload) {
        this(repo, metadataDTO, forceDownload, false);
    }

    public Downloadable(Repo repo, MetadataDTO metadataDTO) {
        this(repo, metadataDTO, false, false);
    }

    private Downloadable() {
    }

    public void setRepo(Repo repo) {
        if (repo == null) {
            throw new NullPointerException("Repository is NULL!");
        }
        this.checkLocked();
        this.repo = repo;
    }

    long getAlreadyDownloaded() {
        return this.alreadyDownloaded;
    }

    void setAlreadyDownloaded(long alreadyDownloaded) {
        this.alreadyDownloaded = alreadyDownloaded;
    }

    public boolean isForce() {
        return this.forceDownload;
    }

    public void setForce(boolean force) {
        this.checkLocked();
        this.forceDownload = force;
    }

    public boolean isFast() {
        return this.fastDownload;
    }

    public void setFast(boolean fast) {
        this.checkLocked();
        this.fastDownload = fast;
    }

    public Repo getRepository() {
        return this.repo;
    }

    boolean hasRepository() {
        return this.repo != null;
    }

    public String getFilename() {
        return FileUtil.getFilename(this.metadataDTO.getPath());
    }

    List<File> getAdditionalDestinations() {
        return Collections.unmodifiableList(this.additionalDestinations);
    }

    public void addAdditionalDestination(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.additionalDestinations.add(file);
    }

    public void addHandler(DownloadableHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.handlers.add(handler);
    }

    protected void setContainer(DownloadableContainer container) {
        this.checkLocked();
        this.container = container;
    }

    public Throwable getError() {
        return this.error;
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Downloadable is locked!");
        }
    }

    void onStart() {
        this.setLocked(true);
        for (DownloadableHandler handler : this.handlers) {
            handler.onStart(this);
        }
    }

    void onAbort(AbortedDownloadException ae) {
        this.setLocked(false);
        this.error = ae;
        for (DownloadableHandler handler : this.handlers) {
            handler.onAbort(this);
        }
        if (this.container != null) {
            this.container.onAbort(this);
        }
    }

    protected void onComplete() throws RetryDownloadException {
        this.setLocked(false);
        for (DownloadableHandler handler : this.handlers) {
            handler.onComplete(this);
        }
        if (this.container != null) {
            this.container.onComplete(this);
        }
    }

    void onError(Throwable e) {
        this.error = e;
        if (e == null) {
            return;
        }
        this.setLocked(false);
        for (DownloadableHandler handler : this.handlers) {
            handler.onError(this, e);
        }
        if (this.container != null) {
            this.container.onError(this, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{path='" + this.metadataDTO.getPath() + "'; repo=" + this.repo + "; destinations=" + this.metadataDTO.getLocalDestination() + "," + this.additionalDestinations + "; force=" + this.forceDownload + "; fast=" + this.fastDownload + "; locked=" + this.locked + "; container=" + this.container + "; handlers=" + this.handlers + "; error=" + this.error + ";}";
    }

    public static HttpURLConnection setUp(URLConnection connection0, int timeout, boolean fake) {
        String userAgent;
        if (connection0 == null) {
            throw new NullPointerException();
        }
        if (!(connection0 instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("Unknown connection protocol: " + connection0);
        }
        HttpURLConnection connection = (HttpURLConnection)connection0;
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setInstanceFollowRedirects(true);
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        if (!fake) {
            return connection;
        }
        switch (OS.CURRENT) {
            case OSX: {
                userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8) AppleWebKit/535.18.5 (KHTML, like Gecko) Version/5.2 Safari/535.18.5";
                break;
            }
            case WINDOWS: {
                userAgent = "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0; .NET4.0C)";
                break;
            }
            default: {
                userAgent = "Mozilla/5.0 (Linux; Linux x86_64; rv:29.0) Gecko/20100101 Firefox/29.0";
            }
        }
        connection.setRequestProperty("User-Agent", userAgent);
        return connection;
    }

    public static HttpURLConnection setUp(URLConnection connection, boolean fake) {
        return Downloadable.setUp(connection, U.getConnectionTimeout(), fake);
    }

    public static String getEtag(String etag) {
        if (etag == null) {
            return "-";
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    public MetadataDTO getMetadataDTO() {
        return this.metadataDTO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        Downloadable that = (Downloadable)o;
        return Objects.equals(this.additionalDestinations, that.additionalDestinations) && Objects.equals(this.repo, that.repo) && Objects.equals(this.metadataDTO, that.metadataDTO);
    }

    public int hashCode() {
        return Objects.hash(this.additionalDestinations, this.repo, this.metadataDTO);
    }
}

