/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.model.Headers;
import by.gdev.http.download.model.RequestMetadata;
import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.HttpService;
import by.gdev.util.DesktopUtil;
import by.gdev.util.model.download.Metadata;
import by.gdev.utils.service.FileMapperService;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheServiceImpl
implements FileCacheService {
    private static final Logger log = LoggerFactory.getLogger(FileCacheServiceImpl.class);
    private HttpService httpService;
    private Gson gson;
    private Charset charset;
    private Path directory;
    private int timeToLife;

    @Override
    public Path getRawObject(String url, boolean cache) throws IOException, NoSuchAlgorithmException {
        Path urlPath = Paths.get(this.directory.toString(), url.replaceAll("://", "_").replaceAll("[:?=]", "_"));
        Path metaFile = Paths.get(String.valueOf(urlPath).concat(".metadata"), new String[0]);
        if (cache) {
            return this.getResourceWithoutHttpHead(url, metaFile, urlPath);
        }
        return this.getResourceWithHttpHead(url, urlPath, metaFile);
    }

    @Override
    public Path getRawObject(List<String> urls, Metadata metadata, boolean cache) throws IOException, NoSuchAlgorithmException {
        Iterator<String> iterator = urls.iterator();
        if (iterator.hasNext()) {
            String url = iterator.next();
            return this.getRawObject(url + metadata.getRelativeUrl(), cache);
        }
        throw new NullPointerException("metadata is empty");
    }

    private Path getResourceWithoutHttpHead(String url, Path metaFile, Path urlPath) throws IOException, NoSuchAlgorithmException {
        long purgeTime = System.currentTimeMillis() - (long)(this.timeToLife * 1000);
        if (urlPath.toFile().lastModified() < purgeTime) {
            Files.deleteIfExists(urlPath);
        }
        if (urlPath.toFile().exists() && Files.exists(metaFile, new LinkOption[0])) {
            RequestMetadata localMetadata = new FileMapperService(this.gson, this.charset, "").read(metaFile.toString(), RequestMetadata.class);
            String sha = DesktopUtil.getChecksum(urlPath.toFile(), Headers.SHA1.getValue());
            if (sha.equals(localMetadata.getSha1())) {
                log.trace("HTTP HEAD -> " + url);
                return urlPath;
            }
            log.trace("not proper hashsum HTTP GET -> " + url);
            RequestMetadata serverMetadata = this.httpService.getRequestByUrlAndSave(url, urlPath);
            this.createSha1(serverMetadata, urlPath, metaFile);
            return urlPath;
        }
        log.trace("HTTP GET -> " + url);
        this.httpService.getRequestByUrlAndSave(url, urlPath);
        this.checkMetadataFile(metaFile, url);
        return urlPath;
    }

    private Path getResourceWithHttpHead(String url, Path urlPath, Path metaFile) throws IOException, NoSuchAlgorithmException {
        boolean fileExists = urlPath.toFile().exists();
        this.checkMetadataFile(metaFile, url);
        if (fileExists) {
            RequestMetadata serverMetadata = this.httpService.getMetaByUrl(url);
            RequestMetadata localMetadata = new FileMapperService(this.gson, this.charset, "").read(metaFile.toString(), RequestMetadata.class);
            if (StringUtils.equals((CharSequence)serverMetadata.getETag(), (CharSequence)localMetadata.getETag()) & StringUtils.equals((CharSequence)serverMetadata.getContentLength(), (CharSequence)localMetadata.getContentLength()) & StringUtils.equals((CharSequence)serverMetadata.getLastModified(), (CharSequence)localMetadata.getLastModified())) {
                return urlPath;
            }
            this.httpService.getRequestByUrlAndSave(url, urlPath);
            new FileMapperService(this.gson, this.charset, "").write(serverMetadata, metaFile.toString());
            return urlPath;
        }
        RequestMetadata serverMetadata = this.httpService.getRequestByUrlAndSave(url, urlPath);
        this.createSha1(serverMetadata, urlPath, metaFile);
        return urlPath;
    }

    private void createSha1(RequestMetadata metadata, Path urlPath, Path metaFile) throws IOException, NoSuchAlgorithmException {
        metadata.setSha1(DesktopUtil.getChecksum(urlPath.toFile(), "SHA-1"));
        new FileMapperService(this.gson, this.charset, "").write(metadata, metaFile.toString());
    }

    private void checkMetadataFile(Path metaFile, String url) throws IOException {
        if (!metaFile.toFile().exists()) {
            RequestMetadata metadata = this.httpService.getMetaByUrl(url);
            new FileMapperService(this.gson, this.charset, "").write(metadata, metaFile.toString());
        }
    }

    public FileCacheServiceImpl(HttpService httpService, Gson gson, Charset charset, Path directory, int timeToLife) {
        this.httpService = httpService;
        this.gson = gson;
        this.charset = charset;
        this.directory = directory;
        this.timeToLife = timeToLife;
    }
}

